#ifdef SYSTEMC
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {

  void Counter::genMealy (void)
  {
    log_printf(FUNC,Counter,"genMealy","Begin");

    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	Tcontrol_t addsub  = PORT_READ(in_COUNTER_ADDSUB [i]);
	Tdata_t    data_in = PORT_READ(in_COUNTER_DATA   [i]);
	Tdata_t    data_out= data_in;
	log_printf(TRACE,Counter,"genMealy","before : %d %s = %d",data_in,((addsub==1)?"++":"--"),data_out);

	// Staturate counter
	if (addsub == 1)
	  {
	    if (data_out < _param._data_max)
	      data_out++;
	  }
	else
	  {
	    if (data_out > 0)
	      data_out--;
	  }

	log_printf(TRACE,Counter,"genMealy","after   : %d %s = %d",data_in,((addsub==1)?"++":"--"),data_out);
    
	PORT_WRITE(out_COUNTER_DATA[i], data_out);
      }

    log_printf(FUNC,Counter,"genMealy","End");
  };

}; // end namespace counter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
#endif
