/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/Types.h"
#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  string Parameters::msg_error(void)
  {
    string msg = "";

    if ((8*sizeof(Tdata_t)) < _size_word)
      {
        msg += "  - type \"Tdata_t\" is too little to the size defined by size_word\n";
        msg +=  "    * size_word                       : " + toString(_size_word) + "\n";
	msg +=  "    * Tdata_t                   (bits): " + toString(8*(sizeof(Tdata_t))) + "\n";
      }

    if ((8*sizeof(Taddress_t)) < log2(_nb_word))
      {
        msg += "  - type \"Taddress_t\" is too little to the size defined by nb_word\n";
        msg +=  "    * nb_word                         : " + toString(_nb_word)    + "\n";
	msg +=  "      > size                   (bits) : " + toString(log2(_nb_word)) + "\n";
	msg +=  "    * Taddress_t               (bits) : " + toString(8*(sizeof(Taddress_t))) + "\n";
      }

    if (_nb_word < 2)
      {
        msg += "  - nb_word must be >= 2\n";
        msg += "    * nb_word                         : " + toString(_nb_word)    + "\n";
      }

    return msg;
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
