#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {
  void RegisterFile_Monolithic::transition (void)
  {
    log_printf(FUNC,Register_File,"transition","Begin");
#ifdef STATISTICS
    _stat_nb_write = 0;
#endif    

    for (uint32_t i=0; i<_param._nb_port_write; i++)
      {
	// Have a write?
 	if ( PORT_READ(in_WRITE_VAL[i]) == true)
 	  {
#ifdef STATISTICS
	    _stat_nb_write ++;
#endif    

	    Taddress_t address = PORT_READ(in_WRITE_ADDRESS[i]);
	    Tdata_t    data    = PORT_READ(in_WRITE_DATA   [i]);
	    
	    log_printf(TRACE,Register_File,"transition","[%d] <- %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

	    // Write in registerFile
	    REGISTER_WRITE(reg_DATA[address],data);
 	  }
      }

#ifdef STATISTICS
    _stat->add(_stat_nb_read,_stat_nb_write);
#endif    

#ifdef VHDL_TESTBENCH
    vhdl_testbench_transition (*_vhdl_testbench);
#endif
    log_printf(FUNC,Register_File,"transition","End");
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
