#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::vhdl_body (Vhdl & vhdl)
  {
    vhdl.set_body ("");
    vhdl.set_body ("-----------------------------------------------------------------------------");
    vhdl.set_body ("-- Read RegisterFile");
    vhdl.set_body ("-----------------------------------------------------------------------------");
    vhdl.set_body ("");
    
    for (uint32_t i = 0; i < _param._nb_port_read; i++)
      {
	vhdl.set_body ("out_READ_ACK_"+toString(i)+"  <= '1';");
	vhdl.set_body ("out_READ_DATA_"+toString(i)+" <= reg_DATA (conv_integer(in_READ_ADDRESS_"+toString(i)+")) when in_READ_VAL_"+toString(i)+" = '1' else "+std_logic_others(_param._size_word,0)+";");
      }
    vhdl.set_body ("");
    vhdl.set_body ("-----------------------------------------------------------------------------");
    vhdl.set_body ("-- Write RegisterFile");
    vhdl.set_body ("-----------------------------------------------------------------------------");
    vhdl.set_body ("");

    vhdl.set_body ("RegisterFile_write: process (in_CLOCK)");
    vhdl.set_body ("begin  -- process RegisterFile_write");
    vhdl.set_body ("\tif in_CLOCK'event and in_CLOCK = '1' then");
    
    for (uint32_t i = 0; i < _param._nb_port_write; i++)
      {
      vhdl.set_body ("\t\tif (in_WRITE_VAL_"+toString(i)+" = '1') then");
      vhdl.set_body ("\t\t\treg_DATA(conv_integer(in_WRITE_ADDRESS_"+toString(i)+")) <= in_WRITE_DATA_"+toString(i)+";");
      vhdl.set_body ("\t\tend if;");
      }

    vhdl.set_body ("\tend if;");
    vhdl.set_body ("end process RegisterFile_write;");

    for (uint32_t i = 0; i < _param._nb_port_write; i++)
      vhdl.set_body ("out_WRITE_ACK_"+toString(i)+"<= '1';");
  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
