#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::vhdl_port (Vhdl & vhdl)
  {
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	vhdl.set_port (" in_SHIFTER_DATA_"+toString(i)+"      ", IN, _param._size_data);
	if (_param._shift_value == 0)
	vhdl.set_port (" in_SHIFTER_SHIFT_"+toString(i)+"     ", IN, static_cast<uint32_t>(ceil(log2(_param._size_data))));
	if (_param._direction   == external_direction)
	vhdl.set_port (" in_SHIFTER_DIRECTION_"+toString(i)+" ", IN, 1);
	if (_param._rotate      == external_rotate)
	vhdl.set_port (" in_SHIFTER_TYPE_"+toString(i)+"      ", IN, 1);
	if (_param._carry       == external_carry)
	vhdl.set_port (" in_SHIFTER_CARRY_"+toString(i)+"     ", IN, 1);
	if (_param._carry       == external_completion)
	if (_param._type_completion_bool == true)
	vhdl.set_port (" in_SHIFTER_CARRY_IN_"+toString(i)+"  ", IN, 1);
	else
	vhdl.set_port (" in_SHIFTER_COMPLETION_"+toString(i)+"", IN, _param._size_data_completion);

	vhdl.set_port ("out_SHIFTER_DATA_"+toString(i)+"      ",OUT, _param._size_data);
      }
  };
}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
