#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::deallocation (void)
  {
    delete in_CLOCK;
    delete in_NRESET;
    // -----[Interface access ]-------------------------------------------
    for (uint32_t i=0; i<_param._nb_access; i++)
      {
	delete  in_ACCESS_VAL     [i];
	delete out_ACCESS_ACK     [i];
	if (_param._size_table>1)
 	delete  in_ACCESS_ADDRESS [i];
	delete out_ACCESS_ENTITY  [i];
      }

    delete  in_ACCESS_VAL    ;
    delete out_ACCESS_ACK    ;
    if (_param._size_table>1)
    delete  in_ACCESS_ADDRESS;
    delete out_ACCESS_ENTITY ;
    
    // -----[Interface update ]-------------------------------------------
    for (uint32_t i=0; i<_param._nb_update; i++)
      {
 	delete  in_UPDATE_VAL     [i];
	delete out_UPDATE_ACK     [i];
	if (_param._size_table>1)
 	delete  in_UPDATE_ADDRESS [i];
	delete  in_UPDATE_ENTITY  [i];
      }
    delete  in_UPDATE_VAL    ;
    delete out_UPDATE_ACK    ;
    if (_param._size_table>1)
    delete  in_UPDATE_ADDRESS;
    delete  in_UPDATE_ENTITY ;

    // -----[Register ]---------------------------------------------------
    for (uint32_t i=0; i<_param._size_table; i++)
      {
 	delete reg_TABLE [i];
      }
    delete reg_TABLE;

    // -----[Internal ]---------------------------------------------------
    delete internal_ACCESS_ENTITY;
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
