#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
  void Vhdl::set_constant (string      name     ,
			   string      type     ,
			   string      init)
  {
    set_list(_list_type, "constant "+ name+"\t: "+type+"\t:= "+init);
  };

  void Vhdl::set_constant (string      name     ,
			   uint32_t    size     ,
			   string      init)
  {
    set_constant(name,std_logic(size),init);
  };

  void Vhdl::set_constant (string      name     ,
			   uint32_t    size     ,
			   uint32_t    init)
  {
    set_constant(name,std_logic(size),std_logic_conv(size,init));
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
