#ifdef SYSTEMC
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {

  void Counter::genMealy (void)
  {
    log_printf(FUNC,Counter,"genMealy","Begin");

    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	Tdata_t data = PORT_READ(in_COUNTER_DATA [i]);

	// Staturate counter
	if (PORT_READ(in_COUNTER_ADDSUB [i]) == 1)
	  {
	    if (data < _param._data_max)
	      data ++;
	  }
	else
	  {
	    if (data > 0)
	      data --;
	  }

	PORT_WRITE(out_COUNTER_DATA[i], data);
      }

    log_printf(FUNC,Counter,"genMealy","End");
  };

}; // end namespace counter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
#endif
