#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_branch_history_table_Branch_History_Table_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_branch_history_table_Branch_History_Table_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Include/ToString.h"
#include "Include/Debug.h"

// Internal structure
#include "Behavioural/Generic/Shifter/include/Shifter.h"
#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  class Branch_History_Table 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
#endif
#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

#ifdef VHDL_TESTBENCH
  private   : Vhdl_Testbench                 * _vhdl_testbench;
#endif

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK                  ;
 
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL            ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK            ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS        ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY        ;

  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_VAL    ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK    ;
  public    : SC_IN (Taddress_t)           **  in_BRANCH_COMPLETE_ADDRESS;
  public    : SC_IN (Thistory_t)           **  in_BRANCH_COMPLETE_HISTORY;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_HIT    ;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_SIGNAL(Thistory_t)        ** signal_BRANCH_COMPLETE_HISTORY;
#endif

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : morpheo::behavioural::generic::shifter::Shifter           * component_Shifter     ;
  protected : morpheo::behavioural::generic::registerfile::RegisterFile * component_RegisterFile;

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Branch_History_Table);
#endif					       
  public  :          Branch_History_Table              (
#ifdef SYSTEMC
							sc_module_name                              name,
#else					       
							string                                      name,
#endif					       
#ifdef STATISTICS
							morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
							Parameters                                  param );
					       
  public  :          Branch_History_Table              (Parameters param );
  public  :          ~Branch_History_Table             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
  public  : void     transition                (void);
#endif
#endif					       
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl & vhdl);
  private : void     vhdl_type                 (Vhdl & vhdl);
  private : void     vhdl_signal               (Vhdl & vhdl);
  private : void     vhdl_body                 (Vhdl & vhdl);
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_port       (void);
  private : void     vhdl_testbench_transition (void);
#endif
  public  : void     vhdl_testbench_label      (string label);
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
