#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Pattern_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace pattern_history_table {


  void Pattern_History_Table::vhdl_testbench_port ()
  {
    log_printf(FUNC,Pattern_History_Table,"vhdl_testbench_port","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->set_port (" in_PREDICT_VAL_"+toString(i)+"             ", IN, 1);
	_vhdl_testbench->set_port ("out_PREDICT_ACK_"+toString(i)+"             ",OUT, 1);
	_vhdl_testbench->set_port (" in_PREDICT_ADDRESS_"+toString(i)+"         ", IN, static_cast<uint32_t>(ceil(log2(_param._nb_counter))));
	_vhdl_testbench->set_port ("out_PREDICT_HISTORY_"+toString(i)+"         ",OUT, _param._size_counter);
      }

     for (uint32_t i=0; i<_param._nb_branch_complete; i++)
       {
	 _vhdl_testbench->set_port (" in_BRANCH_COMPLETE_VAL_"+toString(i)+"    ", IN, 1);
	 _vhdl_testbench->set_port ("out_BRANCH_COMPLETE_ACK_"+toString(i)+"    ",OUT, 1);
	 _vhdl_testbench->set_port (" in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"", IN, static_cast<uint32_t>(ceil(log2(_param._nb_counter))));
	 _vhdl_testbench->set_port (" in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"", IN, _param._size_counter);
	 _vhdl_testbench->set_port (" in_BRANCH_COMPLETE_HIT_"+toString(i)+"    ", IN, 1);
       }

    log_printf(FUNC,Pattern_History_Table,"vhdl_testbench_port","End");
  };

}; // end namespace pattern_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
