#ifndef TEST_H
#define TEST_H

#include <iostream>
#include <sstream>
#include <stdint.h>
using namespace std;

//-----[ Routine de test ]---------------------------------------

static uint32_t num_test;

template <class T>
void test_ko (T exp1, T exp2, char * file, uint32_t line)
{
  cout << "{" << num_test << "} : Test KO" << endl
       << " * Localisation"                << endl
       << "   - File : " << file           << endl
       << "   - Line : " << line           << endl
       << " * Expression is different "    << endl
       << "   - exp1 : " << exp1           << endl
       << "   - exp2 : " << exp2           << endl;

  exit (line);
};

void test_ok ()
{
  cout << "{" << num_test << "} : Test OK" << endl;

  num_test ++;
};

template <class T>
void test(T exp1, T exp2, char * file, uint32_t line)
{
  if (exp1 != exp2)
    test_ko <T> (exp1,exp2,file,line);
  else
    test_ok     ();
};

#define TEST(type,exp1,exp2) do { test<type> (exp1,exp2,__FILE__,__LINE__);} while(0)

#endif
