#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Branch_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  void Branch_History_Table::vhdl_body (Vhdl & vhdl)
  {
    vhdl.set_body ("-- Output : always at '1'");
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      vhdl.set_body ("out_BRANCH_COMPLETE_ACK_"+toString(i)+" <= '1';");
    for (uint32_t i=0; i<_param._nb_prediction     ; i++)
      vhdl.set_body ("out_PREDICT_ACK_"+toString(i)+"         <= '1';");
    vhdl.set_body ("");

    list<string> list_port_map;

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_SHIFTER_DATA_"+toString(i)+"     ","    in_BRANCH_COMPLETE_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_SHIFTER_CARRY_IN_"+toString(i)+" ","    in_BRANCH_COMPLETE_HIT_"+toString(i)    );
	vhdl.set_body_component_port_map (list_port_map,"out_SHIFTER_DATA_"+toString(i)+"     ","signal_BRANCH_COMPLETE_HISTORY_"+toString(i));
      }

    vhdl.set_body_component ("component_Shifter",_name+"_Shifter",list_port_map);


    list_port_map.clear();
    vhdl.set_body_component_port_map (list_port_map,"in_CLOCK","in_CLOCK");
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_READ_ENABLE_"+toString(i)+"  "," in_PREDICT_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_READ_ADDRESS_"+toString(i)+" "," in_PREDICT_ADDRESS_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_READ_DATA_"+toString(i)+"    ","out_PREDICT_HISTORY_"+toString(i));    
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_WRITE_ENABLE_"+toString(i)+" ","    in_BRANCH_COMPLETE_VAL_"+toString(i)+"");
	vhdl.set_body_component_port_map (list_port_map," in_WRITE_ADDRESS_"+toString(i)+"","    in_BRANCH_COMPLETE_ADDRESS_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_WRITE_DATA_"+toString(i)+"   ","signal_BRANCH_COMPLETE_HISTORY_"+toString(i));
      }
    vhdl.set_body_component ("component_RegisterFile",_name+"_RegisterFile",list_port_map);
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
