/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Types.h"
#include <sstream>
using namespace std;

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {

  string Parameters::msg_error(void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor,"msg_error","Begin");

    string msg = "";

    if (is_positive (_nb_prediction) == false)
      {
	msg += "  - nb_prediction must be > 0\n";
	msg += "    * nb_prediction                   : " + toString(_nb_prediction) + "\n";
      }

    if (is_positive (_nb_branch_complete) == false)
      {
	msg += "  - nb_branch_complete must be > 0\n";
	msg += "    * nb_branch_complete              : " + toString(_nb_branch_complete) + "\n";
      }

    if ((_have_bht or _have_pht) == false)
      {
	msg += "  - you have no Branch History Table and no Pattern History Table. You need a less of a BHT or a PHT\n";
	msg += "    * have_bht                        : " + toString(_have_bht) + "\n";
	msg += "    * have_pht                        : " + toString(_have_pht) + "\n";
      }

    if ( _have_bht and (_size_address < _bht_size_address))
      {
	msg += "  - the address's size must to large to the number of shifter in the Branch History Table.\n";
	msg += "    * size_address                    : " + toString(_size_address    ) + "\n";
	msg += "    * have_bht                        : " + toString(_have_bht        ) + "\n";
	msg += "    * bht_size_address                : " + toString(_bht_size_address) + "\n";
	msg += "      * bht_nb_shifter                : " + toString(_bht_nb_shifter  ) + "\n";
      }

    if (_have_pht and ( (_size_address < _pht_size_address) or
			(_have_bht and (_pht_size_address < _bht_size_address))))
      {
	msg += "  - the address's size concate with shifter_out must to large to the number of counter in the Pattern History Table.\n";
	msg += "    * size_address                    : " + toString(_size_address    ) + "\n";
	msg += "    * have_bht                        : " + toString(_have_bht        ) + "\n";
	msg += "    * bht_size_address                : " + toString(_bht_size_address) + "\n";
	msg += "      * bht_nb_shifter                : " + toString(_bht_nb_shifter  ) + "\n";
	msg += "    * have_pht                        : " + toString(_have_bht        ) + "\n";
	msg += "    * pht_size_address                : " + toString(_pht_size_address) + "\n";
	msg += "      * pht_nb_counter                : " + toString(_pht_nb_counter  ) + "\n";
      }

    return msg;

    log_printf(FUNC,Two_Level_Branch_Predictor,"msg_error","End");
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
