#ifndef FILE_H
#define FILE_H

#include <stdint.h>
#include <iostream>
#include "slot.h"

using namespace std;

namespace hierarchy_memory
{
  namespace sort_file
  {
    template <class T>
    class File
    {
    protected : char      * name;
    protected : uint32_t    nb_slot;   // number of slot
    protected : uint32_t    size;      // size of file
    protected : slot_t<T> * slot;

    public : File (char   * name,
		   uint32_t size)
      {
	uint32_t size_name = strlen(name)+1;
	this->name = new char [size_name];
	strncpy(this->name,name,size_name);

	nb_slot    = 0;
	this->size = size;
	slot       = new slot_t<T> [size];
      };

    public : virtual ~File ()
      {
      };

      // *****[ empty ]*****
      // Test if the file is empty
    public : bool empty ()
      {
	return (nb_slot == 0);
      }
      
      // *****[ full ]*****
      // Test if the file is full
    public : bool full ()
      {
	return (nb_slot == size);
      }

      // *****[ nb_slot_free ]*****
      // return the number of free slot
    public : uint32_t nb_slot_free ()
      {
	return (size-nb_slot);
      }

      // *****[ nb_slot_use ]*****
      // return the number of use slot
    public : uint32_t nb_slot_use ()
      {
	return (nb_slot);
      }

      // *****[ pop ]*****
      // read the file, and update the pointer
    public : virtual T    pop  ()             {return T();};

      // *****[ pop ]*****
      // read the file, and update the pointer
    public : virtual T    pop  (uint32_t num) {return T();};

      // *****[ push ]*****
      // Push a new value (they must have a slot free)
    public : virtual bool push (T val)        {return false;};
  
    }; // File
    
  }; //sort_file
}; //hierarchy_memory
#endif //!FILE_H
  
