#ifndef SERVICE_WRITE_H
#define SERVICE_WRITE_H

#include "../sim2os.h"

namespace hierarchy_memory {
  namespace sim2os {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[service_write ]~~~~~
    void *
    Sim2os ::
    service_write ()
    {
      if (have_all_arguments(3) == false)
	{
	  cerr << "<" << NAME << "> Usage : ssize_t write(int fd, void *buf, size_t count);" << endl;
	  return NULL;
	}
  
      int         fd       = (int)          arguments[1];
      const void *buf      = (const void *) convert_address(arguments[2]);
      ssize_t     count    = (ssize_t)      arguments[3];
      void *      result   = (void *)       write(fd,buf,count);
      error                = errno;
  
      // No swap -> because it's a char

      cout << "\n\t***** service : write         *****"        << endl;
      cout << "\tfd        : " <<        (unsigned int) fd     << endl;
      cout << "\tbuf       : " << hex << (unsigned int) buf    << endl;
      //cout << "\tbuf       : " << dec << (char *)       buf    << endl;
      cout << "\tcount     : " << dec << (unsigned int) count  << endl;
      cout << "\tresult    : " <<        (unsigned int) result << endl;
      cout << "\terrno     : " <<        (unsigned int) error  << endl;

      return      result;
    }

  };};
#endif //SERVICE_WRITE_H
