#ifndef morpheo_behavioural_Signal_h
#define morpheo_behavioural_Signal_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include "Behavioural/include/Direction.h"
#include "Behavioural/include/XML.h"
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  typedef enum {PORT_VHDL_YES_TESTBENCH_YES,
		PORT_VHDL_YES_TESTBENCH_NO ,
		PORT_VHDL_NO_TESTBENCH_YES ,
		PORT_VHDL_NO_TESTBENCH_NO  } presence_port_t;

  class Signal
  {
    // -----[fields ]----------------------------------------------------
  public    : const string          _name         ;
  public    : const direction_t     _direction    ;
  public    : const uint32_t        _size         ;
  public    : const presence_port_t _presence_port;

    // -----[methods ]---------------------------------------------------
  public    :                   Signal          (string          name          ,
						 direction_t     direction     ,
						 uint32_t        size          ,
						 presence_port_t presence_port = PORT_VHDL_YES_TESTBENCH_YES);
  public    :                   ~Signal         ();

  public    : XML               toXML           (void);

  public    : friend ostream&   operator<<      (ostream& output_stream,
						 morpheo::behavioural::Signal & x);

  };
}; // end namespace behavioural          

  template<>           inline std::string toString<morpheo::behavioural::presence_port_t>(const morpheo::behavioural::presence_port_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_YES : return "Port is in VHDL's model and TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_YES_TESTBENCH_NO  : return "Port is in VHDL's model                      " ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_YES  : return "Port is in                  TestBench's model" ; break;
      case morpheo::behavioural::PORT_VHDL_NO_TESTBENCH_NO   : return "Port is in none model                        " ; break;
      default                                                : return "";                                               break;
      }
  }

}; // end namespace morpheo              

#endif
