#ifdef CONFIGURATION
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Configuration_Parameters.h"

namespace morpheo              {
namespace behavioural          {
    
  Configuration_Parameters::Configuration_Parameters  (string   name   ,
						       uint32_t value  ,
						       uint32_t min    ,
						       uint32_t max    ,
						       string   step   ,
						       uint32_t value_default,
						       uint32_t level  ,
						       string   comment):
    _name    (name         ),
    _value   (value        ),
    _min     (min          ),
    _max     (max          ),
    _step    (step         ),
    _default (value_default),
    _level   (level        ),
    _comment (comment      )
  {
    if ((value<min) or (value>max))
      throw (ErrorMorpheo ("Parameters \""+name+"\" is out of bound : "+toString(value)+" not include in ["+toString(min)+":"+toString(max)+"]"));
  };
    
  Configuration_Parameters::~Configuration_Parameters () 
  {
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
