#include "window.h"

using namespace std;

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

void Window::winformations()
{
  winfo = new QWidget();
  informations = new QBoxLayout(QBoxLayout::TopToBottom,0);
  winfo->setWindowTitle("informations");
  winfo->setFixedSize(350,292);
  winfo->move(628,50);

  QBoxLayout *bname = new QBoxLayout(QBoxLayout::LeftToRight,0);
  ln = new QLabel();
  ln->setText("");
  lname = new QLabel();
  lname->setText("");
  bname->addWidget(ln);
  bname->addWidget(lname);

  QBoxLayout *btype = new QBoxLayout(QBoxLayout::LeftToRight,0);
  lt = new QLabel();
  lt->setText("");
  ltype = new QLabel();
  ltype->setText("");
  btype->addWidget(lt);
  btype->addWidget(ltype);

  comment = new QLineEdit();
  comment->setText("");
  comment->setReadOnly(true);

  QPushButton *noselect = new QPushButton("cancel selection",wparam);
  QPushButton *back = new QPushButton("back",wparam);
  connect(back,SIGNAL(clicked()),this,SLOT(_back()));
  connect(noselect,SIGNAL(clicked()),this,SLOT(_cancel_selection()));

  informations->addLayout(bname);
  informations->addLayout(btype);
  informations->addWidget(comment);
  informations->addWidget(noselect);
  informations->addWidget(back);

  winfo->setLayout(informations);
  winfo->show();
}

void Window::write_comment(string cm){
  QString c = QString::fromStdString(cm);
  comment->setText(c);
  comment->show();
}

void Window::write_name(string name){
  QString n = QString::fromStdString(name);
  lname->setText(n);
}

void Window::write_type(string type){
  lt->setText("type");
  QString n = QString::fromStdString(type);
  ltype->setText(n);
}

void Window::_cancel_selection(){
  component_clicked = false;
}
