#ifndef morpheo_tools_viewer_parser_h
#define morpheo_tools_viewer_parser_h

#include <qxml.h>
#include <qdom.h>
#include <iostream>
#include <list>
#include <iterator>

#include <qlist.h>
#include "Tools/Viewer/Bdd/include/BaseV.h"
#include "Tools/Viewer/Bdd/include/BaseP.h"
#include "Tools/Viewer/Bdd/include/Entity.h"
#include "Tools/Viewer/Bdd/include/Architecture.h"
#include "Tools/Viewer/Bdd/include/Component.h"
#include "Tools/Viewer/Bdd/include/Port.h"
#include "Tools/Viewer/Bdd/include/PortMap.h"

#define LEVEL_MAX 8

using namespace std;


namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{     

class Parse
{
private:
  string s;
  string absolutePath;
  string toplevel;

  morpheo::tools::viewer::bdd::BaseV *base;
  morpheo::tools::viewer::bdd::BaseP *pos;
  morpheo::tools::viewer::bdd::Entity *ent[LEVEL_MAX];
  morpheo::tools::viewer::bdd::Architecture *arch[LEVEL_MAX];
  morpheo::tools::viewer::bdd::Component *ctemp[LEVEL_MAX];
  
protected:

public:
  
  Parse(void);
  ~Parse(void);
  void parser_pos(QDomNode n,int level);

  int open_file(string name,int level);
  //void saveFile(string name);
  morpheo::tools::viewer::bdd::BaseV *getBaseV();
  string getTopLevelName();
  string getAbsolutePath();
  /*Close and erase baseV*/
  void closeBaseV();
 //void refresh();
 


};//end class parse
};//end parser
};//end viewer
};//end tools
};//end morpheo


#endif
