/********************************************
 * files               : asm_015_shift_rotate.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                :
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.bnf
 *                         l.jal
 *                         l.jr
 *                         l.movhi
 *                         l.ori
 *                         l.sfeq
 ********************************************
 */
	.file	"asm_015_shift_rotate.s"
	.section .text
	.align	4

	.global _asm_015_shift_rotate
_asm_015_shift_rotate :	
	/* save context */
	l.addi	r1,r1,-16
	l.sw	0 (r1),r20
	l.sw	4 (r1),r21
	l.sw	8 (r1),r22
	l.sw	12(r1),r23
	
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	l.movhi	r20, 0x2b3c
	l.ori	r20,r20,0x4d1a

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d
	l.rori	r22,r21, 4
	l.rori	r22,r22, 2
	l.rori	r22,r22, 0
	l.rori	r22,r22, 3
	l.rori	r22,r22, 5
	l.rori	r22,r22, 7
	l.rori	r22,r22, 3

	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d
	
	l.ori 	r23,r0,1
	l.ror	r22,r21,r23
	l.and	r23,r0,r0
	l.ror	r22,r22,r23		
	l.ori	r23,r0,5
	l.ror	r22,r22,r23		
	l.ori 	r23,r0,2
	l.ror	r22,r22,r23		
	l.ori 	r23,r0,5
	l.ror	r22,r22,r23		
	l.ori	r23,r0,3
	l.ror	r22,r22,r23
	l.ori	r23,r0,8
	l.ror	r22,r22,r23	
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	2

	l.movhi	r20, 0x4d00
	l.ori	r20,r20,0x0000

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.slli	r22,r21,4
	l.slli	r22,r22,0
	l.slli	r22,r22,10
	l.slli	r22,r22,7 	
	l.slli	r22,r22,3 
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.ori	r23,r0,4
	l.sll 	r22,r21,r23
	l.ori	r23,r0,0	
	l.sll 	r22,r22,r23
	l.ori	r23,r0,10
	l.sll 	r22,r22,r23
	l.ori	r23,r0,7
	l.sll 	r22,r22,r23	
	l.ori	r23,r0,3
	l.sll 	r22,r22,r23
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r20, 0x0000
	l.ori	r20,r20,0x001a

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.srli	r22,r21,4
	l.srli	r22,r22,0
	l.srli	r22,r22,10
	l.srli	r22,r22,7 	
	l.srli	r22,r22,3 
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.ori	r23,r0,4
	l.srl 	r22,r21,r23
	l.ori	r23,r0,0	
	l.srl 	r22,r22,r23
	l.ori	r23,r0,10
	l.srl 	r22,r22,r23
	l.ori	r23,r0,7
	l.srl 	r22,r22,r23	
	l.ori	r23,r0,3
	l.srl 	r22,r22,r23
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r20, 0x0000
	l.ori	r20,r20,0x001a

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.srai	r22,r21,4
	l.srai	r22,r22,0
	l.srai	r22,r22,10
	l.srai	r22,r22,7 	
	l.srai	r22,r22,3 
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r21, 0x1a2b
	l.ori	r21,r21,0x3c4d

	l.ori	r23,r0,4
	l.sra 	r22,r21,r23
	l.ori	r23,r0,0	
	l.sra 	r22,r22,r23
	l.ori	r23,r0,10
	l.sra 	r22,r22,r23
	l.ori	r23,r0,7
	l.sra 	r22,r22,r23	
	l.ori	r23,r0,3
	l.sra 	r22,r22,r23
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1
	
	l.movhi	r20, 0xffff
	l.ori	r20,r20,0xff8a

	l.movhi	r21, 0x8a2b
	l.ori	r21,r21,0x3c4d

	l.srai	r22,r21,4
	l.srai	r22,r22,0
	l.srai	r22,r22,10
	l.srai	r22,r22,7 	
	l.srai	r22,r22,3 
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1

	l.movhi	r21, 0x8a2b
	l.ori	r21,r21,0x3c4d

	l.ori	r23,r0,4
	l.sra 	r22,r21,r23
	l.ori	r23,r0,0	
	l.sra 	r22,r22,r23
	l.ori	r23,r0,10
	l.sra 	r22,r22,r23
	l.ori	r23,r0,7
	l.sra 	r22,r22,r23	
	l.ori	r23,r0,3
	l.sra 	r22,r22,r23
	l.sfeq	r20,r22
	l.bnf	_asm_015_shift_rotate_ko
	l.nop	1
		
_asm_015_shift_rotate_ok :	
	l.addi	r11,r0,1
_asm_015_shift_rotate_ko :
	
	/* load context */
	l.lwz	r23,12(r1)
	l.lwz	r22,8 (r1)
	l.lwz	r21,4 (r1)
	l.lwz	r20,0 (r1)
	l.jr	r9
	l.addi	r1,r1,16
