#ifdef STATISTICS

#ifndef morpheo_behavioural_Statistics_h
#define morpheo_behavioural_Statistics_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include "Behavioural/include/Parameters_Statistics.h"
#include "Include/Average.h"
#include "Include/Percent.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Statistics
  {
    // -----[fields ]----------------------------------------------------
  protected : const string                _name;
  protected : const Parameters_Statistics _parameters_statistics;

  protected :       uint32_t _nb_statistics;         // nb period ...
  protected :       uint32_t _period_current;        // nb cycle in current period

    // -----[methods ]---------------------------------------------------
  public    :                  Statistics          (string                name                 ,
						    Parameters_Statistics parameters_statistics);
  public    : virtual          ~Statistics         ();

  protected : uint32_t         compute_cycle_begin (uint32_t num_statistics);    
  protected : uint32_t         compute_cycle_end   (uint32_t num_statistics, uint32_t nb_cycle);

  public    : virtual string   print_body          (uint32_t depth) = 0;
  public    : virtual string   print               (uint32_t depth) = 0;
  public    : void             generate_file       (string   stat );
  public    : void             generate_file       (void);

  private   : template <class Counters, class Parameters_Counters> void save        (Counters ** &, Parameters_Counters parameters);
  protected : template <class Counters, class Parameters_Counters> void test_if_save(Counters ** &, Parameters_Counters parameters);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
#endif
