/* *** Paramtre de configuration */

%{
  /*  df des tokens*/
#include "Configuration_files_parser.h"
#include <string.h>

unsigned int lineno = 1;

%}

alpha   		[A-Za-z]
chiffre 		[0-9]
caractere		[-_.]
nom    			({alpha}|{chiffre}|{caractere})

/*----- [ Rules ]------------------------------------- */
%s configuration commentaire

%%
%{
	BEGIN configuration;
%}
<configuration>"<!--"			{ yylval.token = strdup(yytext);  BEGIN(commentaire);   } /* Balise de dbut de commentaires */
<commentaire>"-->"			{ yylval.token = strdup(yytext);  BEGIN(configuration); } /* Balise de fin   de commentaires */


" "|\t					{ yylval.token = strdup(yytext); }
\n    					{ yylval.token = strdup(yytext);  lineno ++;       }


<configuration>"<?xml"			{ yylval.token = strdup(yytext);  return BEGIN_XML; }
<configuration>"?>"			{ yylval.token = strdup(yytext);  return END_XML; }

<configuration>"<cpu"			{ yylval.token = strdup(yytext);  return BEGIN_CPU; }
<configuration>"</cpu"			{ yylval.token = strdup(yytext);  return END_CPU; }

<configuration>"<definition"		{ yylval.token = strdup(yytext);  return BEGIN_DEFINITION; }
<configuration>"</definition"		{ yylval.token = strdup(yytext);  return END_DEFINITION; }

<configuration>"<internal"		{ yylval.token = strdup(yytext);  return BEGIN_INTERNAL; }
<configuration>"</internal"		{ yylval.token = strdup(yytext);  return END_INTERNAL; }

<configuration>"<type"			{ yylval.token = strdup(yytext);  return BEGIN_TYPE; }
<configuration>"</type"			{ yylval.token = strdup(yytext);  return END_TYPE; }

<configuration>"<latence"		{ yylval.token = strdup(yytext);  return BEGIN_LATENCE; }
<configuration>"</latence"		{ yylval.token = strdup(yytext);  return END_LATENCE; }

<configuration>"<global"		{ yylval.token = strdup(yytext);  return BEGIN_GLOBAL; }
<configuration>"</global"		{ yylval.token = strdup(yytext);  return END_GLOBAL; }

<configuration>"<isa"			{ yylval.token = strdup(yytext);  return BEGIN_ISA; }
<configuration>"</isa"			{ yylval.token = strdup(yytext);  return END_ISA; }

<configuration>"<cache"			{ yylval.token = strdup(yytext);  return BEGIN_CACHE; }
<configuration>"</cache"		{ yylval.token = strdup(yytext);  return END_CACHE; }

<configuration>"<icache"		{ yylval.token = strdup(yytext);  return BEGIN_ICACHE; }
<configuration>"</icache"		{ yylval.token = strdup(yytext);  return END_ICACHE; }

<configuration>"<dcache"		{ yylval.token = strdup(yytext);  return BEGIN_DCACHE; }
<configuration>"</dcache"		{ yylval.token = strdup(yytext);  return END_DCACHE; }

<configuration>"<ifetch"		{ yylval.token = strdup(yytext);  return BEGIN_IFETCH; }
<configuration>"</ifetch"		{ yylval.token = strdup(yytext);  return END_IFETCH; }

<configuration>"<prediction"		{ yylval.token = strdup(yytext);  return BEGIN_PREDICTION; }
<configuration>"</prediction"		{ yylval.token = strdup(yytext);  return END_PREDICTION; }

<configuration>"<operation"		{ yylval.token = strdup(yytext);  return BEGIN_OPERATION; }
<configuration>"<allow"		        { yylval.token = strdup(yytext);  return BEGIN_ALLOW; }
<configuration>"<ORBIS"		        { yylval.token = strdup(yytext);  return BEGIN_ORBIS; }
<configuration>"<ORFPX"		        { yylval.token = strdup(yytext);  return BEGIN_ORFPX; }
<configuration>"<ORVDX"		        { yylval.token = strdup(yytext);  return BEGIN_ORVDX; }
<configuration>"<size_data"     	{ yylval.token = strdup(yytext);  return BEGIN_SIZE_DATA       ; }
<configuration>"<scheme_bypass" 	{ yylval.token = strdup(yytext);  return BEGIN_SCHEME_BYPASS   ; }
<configuration>"<arbiter"       	{ yylval.token = strdup(yytext);  return BEGIN_ARBITER         ; }
<configuration>"<nb_port"       	{ yylval.token = strdup(yytext);  return BEGIN_NB_PORT         ; }
<configuration>"<affectation"		{ yylval.token = strdup(yytext);  return BEGIN_AFFECTATION; }

<configuration>"<nb_inst_fetch" 	{ yylval.token = strdup(yytext);  return BEGIN_NB_INST_FETCH   ; }
<configuration>"<size_fetch_queue"	{ yylval.token = strdup(yytext);  return BEGIN_SIZE_FETCH_QUEUE; }
<configuration>"<link_icache"    	{ yylval.token = strdup(yytext);  return BEGIN_LINK_ICACHE     ; }
<configuration>"<link_predictor"	{ yylval.token = strdup(yytext);  return BEGIN_LINK_PREDICTOR  ; }
<configuration>"<link_decod"        	{ yylval.token = strdup(yytext);  return BEGIN_LINK_DECOD      ; }

<configuration>">" 			{ yylval.token = strdup(yytext);  return END_BALISE_DUAL;}
<configuration>"/>" 			{ yylval.token = strdup(yytext);  return END_SINGLETON;}

<configuration>"="                      { yylval.token = strdup(yytext);  return EQUAL; }
<configuration>"\""                     { yylval.token = strdup(yytext);  return QUOTE; }


<configuration>"version"		{ yylval.token = strdup(yytext);  return VERSION         ; }
<configuration>"encoding"		{ yylval.token = strdup(yytext);  return ENCODING        ; }
<configuration>"name"    		{ yylval.token = strdup(yytext);  return NAME            ; }
<configuration>"id"      		{ yylval.token = strdup(yytext);  return ID              ; }
<configuration>"delay"      		{ yylval.token = strdup(yytext);  return DELAY           ; }
<configuration>"latence"      		{ yylval.token = strdup(yytext);  return LATENCE         ; }
<configuration>"type"         		{ yylval.token = strdup(yytext);  return TYPE            ; }
<configuration>"value"        		{ yylval.token = strdup(yytext);  return VALUE           ; }
<configuration>"algo"         		{ yylval.token = strdup(yytext);  return ALGO            ; }

<configuration>"true"           	{ yylval.token = strdup(yytext);  yylval.value_int   = 1;              return INTEGER;}
<configuration>"false"    		{ yylval.token = strdup(yytext);  yylval.value_int   = 0;              return INTEGER;}

<configuration>{chiffre}+"."{chiffre}+	{ yylval.token = strdup(yytext);  yylval.value_float = atof(yytext);   return FLOAT;}
<configuration>{chiffre}+		{ yylval.token = strdup(yytext);  yylval.value_int   = atoi(yytext);   return INTEGER;}
<configuration>{nom}+			{ yylval.token = strdup(yytext);  yylval.name        = strdup(yytext); return STRING;}


<commentaire>.                          { yylval.token = strdup(yytext); }
.                                       { yylval.token = strdup(yytext);  return (*yytext); } /* Toute autre caractre */
%%

/*  *** Fonctions auxiliaire */

int yywrap()
{ 
   return (-1);
}
