/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


#ifdef SYSTEMC
  Counter::Counter (sc_module_name name,
#else
  Counter::Counter (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::generic::counter::Parameters param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,Counter,"Counter","Begin");

#ifdef STATISTICS
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    _vhdl_testbench = new Vhdl_Testbench (_name);
    vhdl_testbench_port           ();
    _vhdl_testbench->set_clock    ("in_CLOCK",false);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
    allocation ();

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);

    SC_METHOD (genMealy);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_port; i++)
      sensitive << *(in_COUNTER_DATA   [i])
		<< *(in_COUNTER_ADDSUB [i]);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	(*(out_COUNTER_DATA [i])) (*(in_COUNTER_DATA   [i]));
	(*(out_COUNTER_DATA [i])) (*(in_COUNTER_ADDSUB [i]));
      }
#endif    

#endif
    log_printf(FUNC,Counter,"Counter","End");
  };
  
  Counter::~Counter (void)
  {
    log_printf(FUNC,Counter,"~Counter","Begin");
#ifdef SYSTEMC
    deallocation ();
#endif

#ifdef VHDL_TESTBENCH
    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif
    log_printf(FUNC,Counter,"~Counter","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
