#ifdef POSITION
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Position.h"

namespace morpheo              {
namespace behavioural          {

  void Position::port_map (string component1,
			   string signal1   ,
			   string component2,
			   string signal2   )
  {
    Entity * entity1 = find_entity(component1);

    if (entity1 == NULL)
      throw (ErrorMorpheo ("Position \""+_entity->_name+"\", port map with unknow component \""+component1+"\"."));

    bool is_top_level1 = _entity->_name == component1;

    Interface * interface1 = find_interface (signal1, entity1);

    if (interface1 == NULL)
      throw (ErrorMorpheo ("Position \""+_entity->_name+"\", port map with component \""+component1+"\" and a unknow port \""+signal1+"\"."));

    Entity * entity2 = find_entity(component2);

    if (entity2 == NULL)
      throw (ErrorMorpheo ("Position \""+_entity->_name+"\", port map with unknow component \""+component2+"\"."));

    bool is_top_level2 = _entity->_name == component2;

    Interface * interface2 = find_interface (signal2, entity2);

    if (interface2 == NULL)
      throw (ErrorMorpheo ("Position \""+_entity->_name+"\", port map with component \""+component2+"\" and a unknow port \""+signal2+"\"."));

    // all is ok
    if (is_top_level1 == false)
      interface1->port_map(static_cast<void *>(entity2   ),
			   static_cast<void *>(interface2));

    if (is_top_level2 == false)
      interface2->port_map(static_cast<void *>(entity1   ),
			   static_cast<void *>(interface1));
    
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
