#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
  void Vhdl::set_signal (string      name     ,
			 string      type     )
  {
    set_list(_list_signal, "signal "+ name + "\t: " + type);
  };

  void Vhdl::set_signal (string      name     ,
			 uint32_t    size     )
  {
    set_signal(name,std_logic(size));
  }

  void Vhdl::set_signal (string      name     ,
			 string      type     ,
			 string      init)
  {
    _list_signal.push_back ("signal "+ name+"\t: "+type+"\t:= "+init);
  };

  void Vhdl::set_signal (string      name     ,
			 uint32_t    size     ,
			 string      init     )
  {
    set_signal(name,std_logic(size),init);
  };
  void Vhdl::set_signal (string      name     ,
			 uint32_t    size     ,
			 uint32_t    init     )
  {
    set_signal(name,std_logic(size),std_logic_conv(size,init));
  };

  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
