#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <math.h>
#include "Behavioural/include/Vhdl.h"

namespace morpheo              {
namespace behavioural          {

  string std_logic (uint32_t size)
  {
    string type;

    if (size == 1)
      type = "std_logic";
    else
      type = "std_logic_vector(" + toString(size-1) + " downto 0)";

    return type;
  };

  string std_logic_conv (uint32_t size, string value)
  {
    string conv;

    if (size == 1)
      conv = "'"+toString(value)+"'";
    else
      conv = "conv_std_logic_vector("+value+","+toString(size)+")";

    return conv;
  };

  string std_logic_conv (uint32_t size, uint32_t value)
  {
    return std_logic_conv(size,toString(value));
  };

  string std_logic_range (uint32_t max, uint32_t min)
  {
    string type;

    if (max == min)
      type = "("+toString(max)+")";
    else
      type = "("+toString(max)+" downto "+toString(min)+")";

    return type;
  };

  string std_logic_range (uint32_t size)
  {
    return std_logic_range(size-1,0);
  }

  string std_logic_others (uint32_t size, uint32_t cst  )
  {
    if (size < 2)
      return "'"+toString(cst)+"'";
    else
      return "(others => '"+toString(cst)+"')";
  }
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
