/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {

  Parameters::Parameters (bool     have_meta_predictor               ,
			  
			  bool     predictor_0_have_bht              ,
			  uint32_t predictor_0_bht_size_shifter      ,
			  uint32_t predictor_0_bht_nb_shifter        ,
			  bool     predictor_0_have_pht              ,
			  uint32_t predictor_0_pht_size_counter      ,
			  uint32_t predictor_0_pht_nb_counter        ,
			  uint32_t predictor_0_pht_size_address_share,
			  
			  bool     predictor_1_have_bht              ,
			  uint32_t predictor_1_bht_size_shifter      ,
			  uint32_t predictor_1_bht_nb_shifter        ,
			  bool     predictor_1_have_pht              ,
			  uint32_t predictor_1_pht_size_counter      ,
			  uint32_t predictor_1_pht_nb_counter        ,
			  uint32_t predictor_1_pht_size_address_share,
			  
			  bool     predictor_2_have_bht              ,
			  uint32_t predictor_2_bht_size_shifter      ,
			  uint32_t predictor_2_bht_nb_shifter        ,
			  bool     predictor_2_have_pht              ,
			  uint32_t predictor_2_pht_size_counter      ,
			  uint32_t predictor_2_pht_nb_counter        ,
			  uint32_t predictor_2_pht_size_address_share,
			  
			  uint32_t size_address                      ,
			  uint32_t nb_prediction                     ,
			  uint32_t nb_branch_complete                ):
    _have_meta_predictor                (have_meta_predictor               ),

    _predictor_0_have_bht               ((have_meta_predictor==false)?false:predictor_0_have_bht              ),
    _predictor_0_bht_size_shifter       ((_predictor_0_have_bht==false)?0:predictor_0_bht_size_shifter      ),
    _predictor_0_bht_nb_shifter         ((_predictor_0_have_bht==false)?0:predictor_0_bht_nb_shifter        ),
    _predictor_0_have_pht               ((have_meta_predictor==false)?false:predictor_0_have_pht              ),
    _predictor_0_pht_size_counter       ((_predictor_0_have_pht==false)?0:predictor_0_pht_size_counter      ),
    _predictor_0_pht_nb_counter         ((_predictor_0_have_pht==false)?0:predictor_0_pht_nb_counter        ),
    _predictor_0_pht_size_address_share (predictor_0_pht_size_address_share),

    _predictor_1_have_bht               ((have_meta_predictor==false)?false:predictor_1_have_bht              ),
    _predictor_1_bht_size_shifter       ((_predictor_1_have_bht==false)?0:predictor_1_bht_size_shifter      ),
    _predictor_1_bht_nb_shifter         ((_predictor_1_have_bht==false)?0:predictor_1_bht_nb_shifter        ),
    _predictor_1_have_pht               ((have_meta_predictor==false)?false:predictor_1_have_pht              ),
    _predictor_1_pht_size_counter       ((_predictor_1_have_pht==false)?0:predictor_1_pht_size_counter      ),
    _predictor_1_pht_nb_counter         ((_predictor_1_have_pht==false)?0:predictor_1_pht_nb_counter        ),
    _predictor_1_pht_size_address_share (predictor_1_pht_size_address_share),

    _predictor_2_have_bht               (predictor_2_have_bht              ),
    _predictor_2_bht_size_shifter       ((_predictor_2_have_bht==false)?0:predictor_2_bht_size_shifter      ),
    _predictor_2_bht_nb_shifter         ((_predictor_2_have_bht==false)?0:predictor_2_bht_nb_shifter        ),
    _predictor_2_have_pht               (predictor_2_have_pht              ),
    _predictor_2_pht_size_counter       ((_predictor_2_have_pht==false)?0:predictor_2_pht_size_counter      ),
    _predictor_2_pht_nb_counter         ((_predictor_2_have_pht==false)?0:predictor_2_pht_nb_counter        ),
    _predictor_2_pht_size_address_share (predictor_2_pht_size_address_share),

    _size_address                       (size_address                      ),
    _nb_prediction                      (nb_prediction                     ),
    _nb_branch_complete                 (nb_branch_complete                ),

    _size_history                       (_predictor_0_bht_size_shifter + _predictor_0_pht_size_counter +
					 _predictor_1_bht_size_shifter + _predictor_1_pht_size_counter +
					 _predictor_2_bht_size_shifter + _predictor_2_pht_size_counter )
  {
    log_printf(FUNC,Meta_Predictor,"Parameters","Begin");
    
    if (_have_meta_predictor)
      {
    _param_two_level_branch_predictor_0 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_0_have_bht              ,
																		      _predictor_0_bht_size_shifter      ,
																		      _predictor_0_bht_nb_shifter        ,
																		      _predictor_0_have_pht              ,
																		      _predictor_0_pht_size_counter      ,
																		      _predictor_0_pht_nb_counter        ,
																		      _predictor_0_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );

    _param_two_level_branch_predictor_1 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_1_have_bht              ,
																		      _predictor_1_bht_size_shifter      ,
																		      _predictor_1_bht_nb_shifter        ,
																		      _predictor_1_have_pht              ,
																		      _predictor_1_pht_size_counter      ,
																		      _predictor_1_pht_nb_counter        ,
																		      _predictor_1_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );
      }

    _param_two_level_branch_predictor_2 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_2_have_bht              ,
																		      _predictor_2_bht_size_shifter      ,
																		      _predictor_2_bht_nb_shifter        ,
																		      _predictor_2_have_pht              ,
																		      _predictor_2_pht_size_counter      ,
																		      _predictor_2_pht_nb_counter        ,
																		      _predictor_2_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );


    _param_meta_predictor_glue = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::meta_predictor_glue::Parameters (_have_meta_predictor               ,
																       _predictor_0_have_bht              ,
																       _predictor_0_bht_size_shifter      ,
																       _predictor_0_have_pht              ,
																       _predictor_0_pht_size_counter      ,
																       _predictor_1_have_bht              ,
																       _predictor_1_bht_size_shifter      ,
																       _predictor_1_have_pht              ,
																       _predictor_1_pht_size_counter      ,
																       _predictor_2_have_bht              ,
																       _predictor_2_bht_size_shifter      ,
																       _predictor_2_have_pht              ,
																       _predictor_2_pht_size_counter      ,
																       _nb_prediction                     ,
																       _nb_branch_complete                );

    test();
    
    log_printf(FUNC,Meta_Predictor,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param):
    _have_meta_predictor                (param._have_meta_predictor               ),

    _predictor_0_have_bht               (param._predictor_0_have_bht              ),
    _predictor_0_bht_size_shifter       (param._predictor_0_bht_size_shifter      ),
    _predictor_0_bht_nb_shifter         (param._predictor_0_bht_nb_shifter        ),
    _predictor_0_have_pht               (param._predictor_0_have_pht              ),
    _predictor_0_pht_size_counter       (param._predictor_0_pht_size_counter      ),
    _predictor_0_pht_nb_counter         (param._predictor_0_pht_nb_counter        ),
    _predictor_0_pht_size_address_share (param._predictor_0_pht_size_address_share),

    _predictor_1_have_bht               (param._predictor_1_have_bht              ),
    _predictor_1_bht_size_shifter       (param._predictor_1_bht_size_shifter      ),
    _predictor_1_bht_nb_shifter         (param._predictor_1_bht_nb_shifter        ),
    _predictor_1_have_pht               (param._predictor_1_have_pht              ),
    _predictor_1_pht_size_counter       (param._predictor_1_pht_size_counter      ),
    _predictor_1_pht_nb_counter         (param._predictor_1_pht_nb_counter        ),
    _predictor_1_pht_size_address_share (param._predictor_1_pht_size_address_share),

    _predictor_2_have_bht               (param._predictor_2_have_bht              ),
    _predictor_2_bht_size_shifter       (param._predictor_2_bht_size_shifter      ),
    _predictor_2_bht_nb_shifter         (param._predictor_2_bht_nb_shifter        ),
    _predictor_2_have_pht               (param._predictor_2_have_pht              ),
    _predictor_2_pht_size_counter       (param._predictor_2_pht_size_counter      ),
    _predictor_2_pht_nb_counter         (param._predictor_2_pht_nb_counter        ),
    _predictor_2_pht_size_address_share (param._predictor_2_pht_size_address_share),

    _size_address                       (param._size_address                      ),
    _nb_prediction                      (param._nb_prediction                     ),
    _nb_branch_complete                 (param._nb_branch_complete                ),
    
    _size_history                       (param._size_history                      )
  {
    log_printf(FUNC,Meta_Predictor,"Parameters","Begin");


    if (_have_meta_predictor)
      {
    _param_two_level_branch_predictor_0 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_0_have_bht              ,
																		      _predictor_0_bht_size_shifter      ,
																		      _predictor_0_bht_nb_shifter        ,
																		      _predictor_0_have_pht              ,
																		      _predictor_0_pht_size_counter      ,
																		      _predictor_0_pht_nb_counter        ,
																		      _predictor_0_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );

    _param_two_level_branch_predictor_1 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_1_have_bht              ,
																		      _predictor_1_bht_size_shifter      ,
																		      _predictor_1_bht_nb_shifter        ,
																		      _predictor_1_have_pht              ,
																		      _predictor_1_pht_size_counter      ,
																		      _predictor_1_pht_nb_counter        ,
																		      _predictor_1_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );
      }

    _param_two_level_branch_predictor_2 = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters (_predictor_2_have_bht              ,
																		      _predictor_2_bht_size_shifter      ,
																		      _predictor_2_bht_nb_shifter        ,
																		      _predictor_2_have_pht              ,
																		      _predictor_2_pht_size_counter      ,
																		      _predictor_2_pht_nb_counter        ,
																		      _predictor_2_pht_size_address_share,
																		      _size_address                      ,
																		      _nb_prediction                     ,
																		      _nb_branch_complete                );
    
    _param_meta_predictor_glue = new morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::meta_predictor_glue::Parameters (_have_meta_predictor               ,
																       _predictor_0_have_bht              ,
																       _predictor_0_bht_size_shifter      ,
																       _predictor_0_have_pht              ,
																       _predictor_0_pht_size_counter      ,
																       _predictor_1_have_bht              ,
																       _predictor_1_bht_size_shifter      ,
																       _predictor_1_have_pht              ,
																       _predictor_1_pht_size_counter      ,
																       _predictor_2_have_bht              ,
																       _predictor_2_bht_size_shifter      ,
																       _predictor_2_have_pht              ,
																       _predictor_2_pht_size_counter      ,
																       _nb_prediction                     ,
																       _nb_branch_complete                );

    test();
    log_printf(FUNC,Meta_Predictor,"Parameters","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,Meta_Predictor,"~Parameters","Begin");

    if (_have_meta_predictor)
      {
    delete _param_two_level_branch_predictor_0;
    delete _param_two_level_branch_predictor_1;
      }
    delete _param_two_level_branch_predictor_2;
    delete _param_meta_predictor_glue;

    log_printf(FUNC,Meta_Predictor,"~Parameters","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
