#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/include/RegisterFile_Multi_Banked_Glue.h"

#ifdef VHDL_TESTBENCH
# define VHDL_SET_PORT(name,direction,size) vhdl.set_port (name,direction,size); _vhdl_testbench->set_port (name,direction,size);
#else
# define VHDL_SET_PORT(name,direction,size) vhdl.set_port (name,direction,size);
#endif

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile{
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {


  void RegisterFile_Multi_Banked_Glue::vhdl_port (Vhdl & vhdl)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"vhdl_port","Begin");

    log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface READ_IN");
   for (uint32_t i=0; i<_param._nb_port_read; i++)
     {
       VHDL_SET_PORT(" in_READ_IN_VAL_"+toString(i)+"      ", IN, 1);
       VHDL_SET_PORT("out_READ_IN_ACK_"+toString(i)+"      ",OUT, 1);
       VHDL_SET_PORT(" in_READ_IN_ADDRESS_"+toString(i)+"  ", IN, _param._size_address);
       VHDL_SET_PORT("out_READ_IN_DATA_"+toString(i)+"     ",OUT, _param._size_word   );
     }

   log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface READ_SELECT");
   	
   for (uint32_t i=0; i<_param._nb_bank; i++)
     {
       log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","READ_SELECT[%d]",i);
       for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	 {
	   log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","READ_SELECT[%d][%d]",i,j);
	   for (uint32_t k=0; k<_param._nb_port_select_by_bank_read_port [j]; k++)
	     {
	       log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","READ_SELECT[%d][%d][%d]",i,j,k);
	       VHDL_SET_PORT("out_READ_SELECT_VAL_"+toString(i)+"_"+toString(j)+"_"+toString(k)+" ",OUT, 1);
	       VHDL_SET_PORT(" in_READ_SELECT_ACK_"+toString(i)+"_"+toString(j)+"_"+toString(k)+" ", IN, 1);
	     }
	 }
     }
   log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface READ_OUT");
    
    for (uint32_t i=0; i<_param._nb_bank; i++)
      for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	{
	  VHDL_SET_PORT("out_READ_OUT_VAL_"+toString(i)+"_"+toString(j)+"      ",OUT, 1);
	  VHDL_SET_PORT(" in_READ_OUT_ACK_"+toString(i)+"_"+toString(j)+"      ", IN, 1);
	  VHDL_SET_PORT("out_READ_OUT_ADDRESS_"+toString(i)+"_"+toString(j)+"  ",OUT, _param._size_address);
	  VHDL_SET_PORT(" in_READ_OUT_DATA_"+toString(i)+"_"+toString(j)+"     ", IN, _param._size_word   );
	}

    log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface WRITE_IN");
    
   for (uint32_t i=0; i<_param._nb_port_write; i++)
     {
       VHDL_SET_PORT(" in_WRITE_IN_VAL_"+toString(i)+"     ", IN, 1);
       VHDL_SET_PORT("out_WRITE_IN_ACK_"+toString(i)+"     ",OUT, 1);
       VHDL_SET_PORT(" in_WRITE_IN_ADDRESS_"+toString(i)+" ", IN, _param._size_address);
       VHDL_SET_PORT(" in_WRITE_IN_DATA_"+toString(i)+"    ", IN, _param._size_word   );
     }
   
   log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface WRITE_SELECT");

   for (uint32_t i=0; i<_param._nb_bank; i++)
     for (uint32_t j=0; j<_param._nb_port_write_by_bank; j++)
       for (uint32_t k=0; k<_param._nb_port_select_by_bank_write_port [j]; k++)
	 {
	   VHDL_SET_PORT("out_WRITE_SELECT_VAL_"+toString(i)+"_"+toString(j)+"_"+toString(k)+" ",OUT, 1);
	   VHDL_SET_PORT(" in_WRITE_SELECT_ACK_"+toString(i)+"_"+toString(j)+"_"+toString(k)+" ", IN, 1);
	 }
   
   log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"vhdl_port","Interface WRITE_OUT");
    
   for (uint32_t i=0; i<_param._nb_bank; i++)
     for (uint32_t j=0; j<_param._nb_port_write_by_bank; j++)
       {
	 VHDL_SET_PORT("out_WRITE_OUT_VAL_"+toString(i)+"_"+toString(j)+"     ",OUT, 1);
	 VHDL_SET_PORT(" in_WRITE_OUT_ACK_"+toString(i)+"_"+toString(j)+"     ", IN, 1);
	 VHDL_SET_PORT("out_WRITE_OUT_ADDRESS_"+toString(i)+"_"+toString(j)+" ",OUT, _param._size_address);
	 VHDL_SET_PORT("out_WRITE_OUT_DATA_"+toString(i)+"_"+toString(j)+"    ",OUT, _param._size_word   );
       }

    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"vhdl_port","End");
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
