#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::genMealy_predict_history (void)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_predict_history","Begin");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	Thistory_t     history = 0;
	Tpht_history_t predictor_0_pht_history  =0, predictor_1_pht_history  =0, predictor_2_pht_history  =0;
	Tbht_history_t predictor_0_bht_history  =0, predictor_1_bht_history  =0, predictor_2_bht_history  =0;
	Tcontrol_t     predictor_0_pht_direction=0, predictor_1_pht_direction=0, predictor_2_pht_direction=0;
	Tcontrol_t     predictor_0_bht_direction=0, predictor_1_bht_direction=0, predictor_2_bht_direction=0;
	Tcontrol_t     predictor_0_direction,     predictor_1_direction,     predictor_2_direction;
	Tcontrol_t     predictor_direction;

	if (_param._predictor_2_have_pht)
	  {
	predictor_2_pht_history   = PORT_READ(in_PREDICT_PREDICTOR_2_PHT_HISTORY [i]);
	predictor_2_pht_direction = predictor_2_pht_history >> (_param._predictor_2_pht_size_counter-1);
	history                  |= (predictor_2_pht_history << _param._shift_5);
	  }
	if (_param._predictor_2_have_bht)
	  {
	predictor_2_bht_history   = PORT_READ(in_PREDICT_PREDICTOR_2_BHT_HISTORY [i]);
	predictor_2_bht_direction = predictor_2_bht_history >> (_param._predictor_2_bht_size_shifter-1);
	history                  |= (predictor_2_bht_history << _param._shift_4);
	  }

	predictor_2_direction = (_param._predictor_2_have_pht==true)?predictor_2_pht_direction:predictor_2_bht_direction;

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_pht)
	  {
	predictor_1_pht_history   = PORT_READ(in_PREDICT_PREDICTOR_1_PHT_HISTORY [i]);
	predictor_1_pht_direction = predictor_1_pht_history >> (_param._predictor_1_pht_size_counter-1);
	history                  |= (predictor_1_pht_history << _param._shift_3);
	  }
	if (_param._predictor_1_have_bht)
	  {
	predictor_1_bht_history   = PORT_READ(in_PREDICT_PREDICTOR_1_BHT_HISTORY [i]);
	predictor_1_bht_direction = predictor_1_bht_history >> (_param._predictor_1_bht_size_shifter-1);
	history                  |= (predictor_1_bht_history << _param._shift_2) ;
	  }
	if (_param._predictor_0_have_pht)
	  {
	predictor_0_pht_history   = PORT_READ(in_PREDICT_PREDICTOR_0_PHT_HISTORY [i]);
	predictor_0_pht_direction = predictor_0_pht_history >> (_param._predictor_0_pht_size_counter-1);
	history                  |= (predictor_0_pht_history << _param._shift_1);
	  }
	if (_param._predictor_0_have_bht)
	  {
	predictor_0_bht_history   = PORT_READ(in_PREDICT_PREDICTOR_0_BHT_HISTORY [i]);
	predictor_0_bht_direction = predictor_0_bht_history >> (_param._predictor_0_bht_size_shifter-1);
	history                  |= (predictor_0_bht_history << _param._shift_0);
	  }

	predictor_0_direction = (_param._predictor_0_have_pht==true)?predictor_0_pht_direction:predictor_0_bht_direction;
	predictor_1_direction = (_param._predictor_1_have_pht==true)?predictor_1_pht_direction:predictor_1_bht_direction;

	// Meta predictor : take direction of prediction_2 and select the good predictor.
	predictor_direction   = (predictor_2_direction==0)?predictor_0_direction:predictor_1_direction;
	
	log_printf(TRACE,Meta_Predictor_Glue,"genMealy_predict_history","predict_direction = %d - predictor(_0 %d, _1 %d, _2 %d)",predictor_direction,predictor_0_direction,predictor_1_direction,predictor_2_direction);
	  }
	else
	  {
	predictor_direction   =  predictor_2_direction;
	log_printf(TRACE,Meta_Predictor_Glue,"genMealy_predict_history","predict_direction = %d - predictor_2 %d",predictor_direction,predictor_2_direction);
	  }

	PORT_WRITE(out_PREDICT_DIRECTION [i], predictor_direction);
	PORT_WRITE(out_PREDICT_HISTORY   [i], history            );
      }

    log_printf(FUNC,Meta_Predictor_Glue,"genMealy_predict_history","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
