#ifndef SERVICE_LSEEK_H
#define SERVICE_LSEEK_H

#include "../sim2os.h"

namespace hierarchy_memory {
  namespace sim2os {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[service_lseek ]~~~~~
    void *
    Sim2os ::
    service_lseek ()
    {
      if (have_all_arguments(3) == false)
	{
	  cerr << "<" << NAME << "> Usage : off_t lseek(int fildes, off_t offset, int whence);" << endl;
	  return NULL;
	}
  
      int         flides   = (int)    arguments[1];
      off_t       offset   = (off_t)  arguments[2];
      int         whence   = (int)    arguments[3];
      void *      result   = (void *) lseek(flides,offset,whence);
      error                = errno;
  
      // No swap -> because no access memory

      cout << "\n\t***** service : lseek         *****"        << endl;
      cout << "\tflides    : " << (unsigned int) flides << endl;
      cout << "\toffset    : " << (unsigned int) offset << endl;
      cout << "\twhence    : " << (unsigned int) whence << endl;
      cout << "\tresult    : " << (unsigned int) result << endl;
      cout << "\terrno     : " << (unsigned int) error  << endl;

      return      result;
    }

  };};
#endif //SERVICE_LSEEK_H
