#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::vhdl_declaration (Vhdl & vhdl)
  {
    log_printf(FUNC,Meta_Predictor,"vhdl_declaration","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	vhdl.set_signal("signal_PREDICT_PREDICTOR_0_ACK_"+toString(i)+"", 1);
	vhdl.set_signal("signal_PREDICT_PREDICTOR_1_ACK_"+toString(i)+"", 1);
	  }
	vhdl.set_signal("signal_PREDICT_PREDICTOR_2_ACK_"+toString(i)+"", 1);

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"", _param._predictor_0_bht_size_shifter);
	if (_param._predictor_0_have_pht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"", _param._predictor_0_pht_size_counter);
	if (_param._predictor_1_have_bht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"", _param._predictor_1_bht_size_shifter);
	if (_param._predictor_1_have_pht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"", _param._predictor_1_pht_size_counter);
	  }
	if (_param._predictor_2_have_bht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"", _param._predictor_2_bht_size_shifter);
	if (_param._predictor_2_have_pht)
	vhdl.set_signal("signal_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"", _param._predictor_2_pht_size_counter);
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {									      					      
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i)+"      ", 1);
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i)+"      ", 1);
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i)+"      ", 1);
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i)+"", 1);
	  }
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i)+"      ", 1);

	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"", _param._predictor_0_bht_size_shifter);
	if (_param._predictor_0_have_pht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"", _param._predictor_0_pht_size_counter);
	if (_param._predictor_1_have_bht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"", _param._predictor_1_bht_size_shifter);
	if (_param._predictor_1_have_pht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"", _param._predictor_1_pht_size_counter);
	  }
	if (_param._predictor_2_have_bht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"", _param._predictor_2_bht_size_shifter);
	if (_param._predictor_2_have_pht)
	vhdl.set_signal("signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"", _param._predictor_2_pht_size_counter);
      }


    log_printf(FUNC,Meta_Predictor,"vhdl_declaration","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
