#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


  void Counter::allocation (void)
  {
    string rename;

    log_printf(FUNC,Counter,"allocation","Begin");

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
#endif

     in_COUNTER_DATA  = new SC_IN (Tdata_t)    * [_param._nb_port];
     in_COUNTER_ADDSUB= new SC_IN (Tcontrol_t) * [_param._nb_port];
    out_COUNTER_DATA  = new SC_OUT(Tdata_t)    * [_param._nb_port];
    
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	rename = " in_COUNTER_DATA_" +toString(i);
	 in_COUNTER_DATA  [i] = new SC_IN (Tdata_t)    (rename.c_str());

	rename = " in_COUNTER_ADDSUB_"+toString(i);
	 in_COUNTER_ADDSUB[i] = new SC_IN (Tcontrol_t) (rename.c_str());

	rename = "out_COUNTER_DATA_" +toString(i);
	out_COUNTER_DATA  [i] = new SC_OUT(Tdata_t)    (rename.c_str());
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    log_printf(FUNC,Counter,"allocation","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
