#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/include/RegisterFile_Multi_Banked_Glue.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile{
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {

  void RegisterFile_Multi_Banked_Glue::genMealy_read_in (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","Begin");
    
    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	log_printf(ALL,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","read_in [%d]",i);

	uint32_t num_bank        = PORT_READ(in_READ_IN_ADDRESS [i])>>_param._shift_address;
	uint32_t num_port_out    = *link_port_read_in_to_out    (i,num_bank);
	uint32_t num_port_select = *link_port_read_in_to_select (i,num_bank);

	if (_param._crossbar == FULL_CROSSBAR) 
	  {
	    // scearch in all possible destination the good
	    // if not found : num_port = 0
	    for (num_port = _param._nb_port_read_by_bank-1; num_port > 0; num_port --)
	      {
		log_printf(ALL,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","test read_out_port   %d",num_port);		
		
		for (uint32_t j=0; j<_param._nb_port_select_by_bank_read_port [num_port]; j++)
		  {
                log_printf(ALL,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","test read_out_select %d",j);
		    if (PORT_READ(in_READ_SELECT_ACK [num_bank][num_port][j])==1)
		      goto end_FULL_CROSSBAR;
		  }
	      }
	  }
	
	end_FULL_CROSSBAR :	
	  
	log_printf(TRACE,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","read_in [%d] address : %.8x - num_bank %d, num_port %d",i,static_cast<uint32_t>(PORT_READ(in_READ_IN_ADDRESS [i])),num_bank,num_port);
	
	PORT_WRITE(out_READ_IN_ACK  [i],PORT_READ(in_READ_SELECT_ACK [num_bank][num_port]));
	PORT_WRITE(out_READ_IN_DATA [i],PORT_READ(in_READ_OUT_DATA   [num_bank][num_port]));
// 	(*(out_READ_IN_ACK  [l])) (*(in_READ_IN_ADDRESS [i][j]));
// 	(*(out_READ_IN_DATA [l])) (*(in_READ_IN_ADDRESS [i][j]));
      }


    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"genMealy_read_in","End");
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
