#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/include/RegisterFile_Multi_Banked_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile{
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {


  void RegisterFile_Multi_Banked_Glue::vhdl_testbench_transition ()
  {
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"vhdl_testbench_transition","Begin");

    // Evaluation before read the ouput signal
    sc_start(0);

    // In order with file RegisterFile_Multi_Banked_Glue_vhdl_testbench_port.cpp
    // Warning : if a output depend of a subcomponent, take directly the port of subcomponent
    // (because we have no control on the ordonnancer's policy)

    //_vhdl_testbench->add_input (PORT_READ( in_NRESET));
    
   for (uint32_t i=0; i<_param._nb_port_read; i++)
     {
       _vhdl_testbench->add_input (PORT_READ( in_READ_IN_VAL       [i]));
       _vhdl_testbench->add_output(PORT_READ(out_READ_IN_ACK       [i]));
       _vhdl_testbench->add_input (PORT_READ( in_READ_IN_ADDRESS   [i]));
       _vhdl_testbench->add_input (PORT_READ(out_READ_IN_DATA      [i]));
     }

   for (uint32_t i=0; i<_param._nb_bank; i++)
     for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
       for (uint32_t k=0; k<_param._nb_port_select_by_bank_read_port [j]; k++)
	 {
	   _vhdl_testbench->add_output(PORT_READ(out_READ_SELECT_VAL [i][j][k]));
	   _vhdl_testbench->add_input (PORT_READ( in_READ_SELECT_ACK [i][j][k]));
	 }
   
    for (uint32_t i=0; i<_param._nb_bank; i++)
      for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	{
	  _vhdl_testbench->add_output(PORT_READ(out_READ_OUT_VAL      [i][j]));
	  _vhdl_testbench->add_input (PORT_READ( in_READ_OUT_ACK      [i][j]));
	  _vhdl_testbench->add_output(PORT_READ(out_READ_OUT_ADDRESS  [i][j]));
	  _vhdl_testbench->add_input (PORT_READ( in_READ_OUT_DATA     [i][j]));
	}

   for (uint32_t i=0; i<_param._nb_port_write; i++)
     {
       _vhdl_testbench->add_input (PORT_READ( in_WRITE_IN_VAL      [i]));
       _vhdl_testbench->add_output(PORT_READ(out_WRITE_IN_ACK      [i]));
       _vhdl_testbench->add_input (PORT_READ( in_WRITE_IN_ADDRESS  [i]));
       _vhdl_testbench->add_input (PORT_READ( in_WRITE_IN_DATA     [i]));
     }
   
   for (uint32_t i=0; i<_param._nb_bank; i++)
     for (uint32_t j=0; j<_param._nb_port_write_by_bank; j++)
       for (uint32_t k=0; k<_param._nb_port_select_by_bank_write_port [j]; k++)
	 {
	   _vhdl_testbench->add_output(PORT_READ(out_WRITE_SELECT_VAL [i][j][k]));
	   _vhdl_testbench->add_input (PORT_READ( in_WRITE_SELECT_ACK [i][j][k]));
	 }
   
    for (uint32_t i=0; i<_param._nb_bank; i++)
      for (uint32_t j=0; j<_param._nb_port_write_by_bank; j++)
	{
	  _vhdl_testbench->add_output(PORT_READ(out_WRITE_OUT_VAL     [i][j]));
	  _vhdl_testbench->add_input (PORT_READ( in_WRITE_OUT_ACK     [i][j]));
	  _vhdl_testbench->add_output(PORT_READ(out_WRITE_OUT_ADDRESS [i][j]));
	  _vhdl_testbench->add_output(PORT_READ(out_WRITE_OUT_DATA    [i][j]));
	}
    

    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    _vhdl_testbench->add_test(true);

    _vhdl_testbench->new_cycle (); // always at the end

    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"vhdl_testbench_transition","End");
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
