#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {


  void Victim_Pseudo_LRU::vhdl_testbench_port (Vhdl_Testbench & vhdl_testbench)
  {
    vhdl_testbench.set_port (" in_NRESET",IN ,1);
    for (uint32_t i = 0; i < _param._nb_access; i ++)
      {
	vhdl_testbench.set_port (" in_ACCESS_VAL_"+toString(i)+"     ",IN ,1);
	vhdl_testbench.set_port ("out_ACCESS_ACK_"+toString(i)+"     ",OUT,1);
	if (_param._size_table>1)
	  vhdl_testbench.set_port (" in_ACCESS_ADDRESS_"+toString(i)+" ",IN ,static_cast<uint32_t>(log2(_param._size_table)));
	vhdl_testbench.set_port ("out_ACCESS_ENTITY_"+toString(i)+"  ",OUT,static_cast<uint32_t>(log2(_param._nb_entity)));
      }

    for (uint32_t i = 0; i < _param._nb_update; i ++)
      {
	vhdl_testbench.set_port (" in_UPDATE_VAL_"+toString(i)+"     ",IN ,1);
	vhdl_testbench.set_port ("out_UPDATE_ACK_"+toString(i)+"     ",OUT,1);
	if (_param._size_table>1)
	  vhdl_testbench.set_port (" in_UPDATE_ADDRESS_"+toString(i)+" ",IN ,static_cast<uint32_t>(log2(_param._size_table)));
	vhdl_testbench.set_port (" in_UPDATE_ENTITY_"+toString(i)+"  ",IN ,static_cast<uint32_t>(log2(_param._nb_entity)));
      }
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
