#ifndef morpheo_behavioural_@DEFINE_@COMPONENT_h
#define morpheo_behavioural_@DEFINE_@COMPONENT_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Include/ToString.h"
#include "Include/Debug.h"

#include "Behavioural/@DIRECTORY/include/Parameters.h"
#include "Behavioural/@DIRECTORY/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/@DIRECTORY/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
@NAMESPACE_BEGIN

  class @COMPONENT 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

#ifdef VHDL_TESTBENCH
  private   : Vhdl_Testbench                 * _vhdl_testbench;
#endif

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (@COMPONENT);
#endif
  public  :          @COMPONENT              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      string                                      name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					      Parameters                                  param );
					       
  public  :          @COMPONENT              (Parameters param );
  public  :          ~@COMPONENT             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                (void);
//#endif
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl & vhdl);
  private : void     vhdl_declaration          (Vhdl & vhdl);
  private : void     vhdl_body                 (Vhdl & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  public  : void     vhdl_testbench_label      (string label);
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
