/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Parameters.h"
#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {


  string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor,"print","Begin");

    string tab = string(depth,'\t');
    ostringstream msg;
    msg << tab << "<two_level_branch_predictor>" << endl
	<< tab << "\t<have bht               value=\"" << _have_bht               << "\" /> <!-- size bht : " << _bht_size_shifter * _bht_nb_shifter << " bits -->" << endl
	<< tab << "\t<bht_size_shifter       value=\"" << _bht_size_shifter       << "\" />" << endl
	<< tab << "\t<bht_nb_shifter         value=\"" << _bht_nb_shifter         << "\" />" << endl
	<< tab << "\t<have pht               value=\"" << _have_pht               << "\" /> <!-- size pht : " << _pht_size_counter * _pht_nb_counter << " bits -->" << endl
	<< tab << "\t<pht_size_counter       value=\"" << _pht_size_counter       << "\" />" << endl
	<< tab << "\t<pht_nb_counter         value=\"" << _pht_nb_counter         << "\" />" << endl
	<< tab << "\t<pht_size_address_share value=\"" << _pht_size_address_share << "\" />" << endl
	<< tab << "\t<size_address           value=\"" << _size_address           << "\" />" << endl
	<< tab << "\t<nb_prediction          value=\"" << _nb_prediction          << "\" />" << endl
	<< tab << "\t<nb_branch_complete     value=\"" << _nb_branch_complete     << "\" />" << endl;
    if (_have_bht)
    msg << _param_branch_history_table ->print(depth+1);
    if (_have_pht)
    msg << _param_pattern_history_table->print(depth+1);
    msg << _param_two_level_branch_predictor_glue->print(depth+1);
    msg << tab << "</two_level_branch_predictor>" << endl;

    log_printf(FUNC,Two_Level_Branch_Predictor,"print","End");
    
    return msg.str();
  };

  ostream& operator<< (ostream& output_stream ,
		       morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Parameters & x)
  {
    output_stream << x.print(0);
    
    return output_stream;
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
