#ifdef VHDL_TESTBENCH

#ifndef morpheo_behavioural_Vhdl_Testbench_h
#define morpheo_behavioural_Vhdl_Testbench_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Include/ToString.h"
#include "Include/ToBase2.h"
#include <stdint.h>
#include <iostream>
#include <list>

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Vhdl_Testbench
  {
    class label_t
    {
    public : const uint32_t _cycle;
    public : const string   _label;

      label_t (uint32_t cycle,
	       string   label) :
	_cycle (cycle),
	_label (label)
      {};
    };

    // -----[fields ]----------------------------------------------------
  private   : const string     _name       ;
  private   : string           _clock_name ;
  private   : uint32_t         _num_cycle  ;

  private   : uint32_t         _size_input ;
  private   : uint32_t         _size_output;

  private   : list<string>     _list_input ;
  private   : list<string>     _list_input_cycle;
  private   : list<uint32_t>   _list_input_size ;
  private   : list<string>     _list_output;
  private   : list<string>     _list_output_cycle;
  private   : list<uint32_t>   _list_output_size ;
  private   : list<bool>       _list_test;
  private   : list<string>     _list_port;
  private   : list<label_t>    _list_label;

  private   : list<uint32_t>::iterator   _num_input ;
  private   : list<uint32_t>::iterator   _num_output;

  private   : Vhdl           * _vhdl;
    
    // -----[methods ]---------------------------------------------------
  public    :                  Vhdl_Testbench              (string   name);
  public    : virtual          ~Vhdl_Testbench             ();
						           
  public    : void             generate_file               (void);

  public    : void             set_port                    (string      name      ,
							    direction_t direction ,
							    uint32_t    size      );
  public    : void             set_clock                   (string      name      ,
							    bool        model_have_clock);
  public    : void             new_cycle                   (void);

  private   : uint32_t         get_input                   (void);
  private   : void             set_input                   (void);
  public    : void             add_input                   (uint32_t    value     );

  private   : uint32_t         get_output                  (void);
  private   : void             set_output                  (void);
  public    : void             add_output                  (uint32_t    value     );

  private   : uint32_t         get_test                    (void);
  public    : void             add_test                    (bool        must_test );

  private   : void             get_label                   (void);
  public    : void             add_label                   (string      label     );

  private   : void             generate_process_clock      (uint32_t    counter   );
  private   : void             generate_instance           (void);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
#endif
