#ifndef morpheo_behavioural_Interfaces_h
#define morpheo_behavioural_Interfaces_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Interface.h"
#include "Include/ToString.h"
#include "Include/Debug.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Interfaces
  {
    // -----[fields ]----------------------------------------------------
  private   : list<Interface>     * _list_interface;

    // -----[methods ]---------------------------------------------------
  public    :                       Interfaces            (void);
  public    :                       Interfaces            (const Interfaces & interfaces);
  public    :                       ~Interfaces           ();

  public    : Interface *           set_interface         (string         name        ,
							   direction_t    direction   ,
							   localisation_t localisation);
  public    : Interface *           set_interface         (string         name        ,
							   direction_t    direction   ,
							   localisation_t localisation,
							   string         comment     );
  private   : string                get_interface         (void);

#ifdef VHDL
  public    : void                  set_port              (Vhdl           * & vhdl          );
#endif
#ifdef VHDL_TESTBENCH
  public    : void                  set_port              (Vhdl_Testbench * & vhdl_testbench);
#endif

  public    : Interface  *          find_interface        (string name);

  public    : XML                   toXML                 (void);
#ifdef POSITION
  public    : XML                   toXML_mapping         (void);
#endif
  public    : friend ostream&       operator<<            (ostream& output_stream,
  					  		   morpheo::behavioural::Interfaces & x);

  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
