#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
  string Vhdl::get_model(uint32_t depth            ,
			 string   filename         ,
			 string   entity_name      ,
			 string   architecture_name)
  {
    log_printf(FUNC,Behavioural,"get_model","Begin");

    string        tab = string(depth,'\t');
    ostringstream text;

    text << tab << get_header       (depth,filename)                      << endl
	 << tab << get_library_ieee (depth)                               << endl
	 << tab << get_library_work (depth)                               << endl
	 << tab << get_entity       (depth,entity_name)                   << endl
	 << tab << get_architecture (depth,architecture_name,entity_name) << endl;
    
    log_printf(FUNC,Behavioural,"get_model","End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
