#ifdef POSITION
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Entity.h"

namespace morpheo              {
namespace behavioural          {

  Entity::Entity  (string       name   ,
		   string       type   ,
		   schema_t     schema):
    _name       (name      ),
    _type       (type      ),
    _schema     (schema    )
  {
    log_printf(FUNC,Behavioural,"Entity","Begin");
    _is_map = false;
    log_printf(FUNC,Behavioural,"Entity","End");
  };

  Entity::Entity  (const Entity & entity):
    _name       (entity._name      ),
    _type       (entity._type      ),
    _schema     (entity._schema    )
  {
    log_printf(FUNC,Behavioural,"Entity (copy)","Begin");
    _is_map     = entity._is_map    ;
    _interfaces = entity._interfaces;
    _comment    = entity._comment   ;
    log_printf(FUNC,Behavioural,"Entity (copy)","End");
  };
  
  Entity::~Entity ()
  {
    log_printf(FUNC,Behavioural,"~Entity","Begin");
    delete _interfaces;
    log_printf(FUNC,Behavioural,"~Entity","End");
  };
  

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
