#include "window.h"

using namespace std;

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace morpheo::tools::viewer::graphics;

/*parameters window constructor*/
void Window::wparameters()
{
  wparam = new QMainWindow();
  //  wparam = new QWidget();
  parameters = new QBoxLayout(QBoxLayout::TopToBottom,0);
  wparam->setWindowTitle("parameters");
  wparam->setFixedSize(370,415);
  wparam->move(628,255);
  wparam->setLayout(parameters);
  sc = new QScrollArea(wparam);
  wscroll = new QWidget();
  sc->setWidgetResizable(false);
  sc->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  sc->setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
  sc->setGeometry(2,2,365,410);
  wparam->show();
}

/*display the parameters*/
void Window::display_param(){

  pbox = new QBoxLayout(QBoxLayout::TopToBottom,0);

  string scpu;
  string lgroup;
  string sparam;
  string ecart;
  
  if(!apply_display){
    QPushButton *apply = new QPushButton("apply",wparam);
    connect(apply,SIGNAL(clicked()),this,SLOT(_apply()));
    apply->setFixedSize(310,25); 
    pbox->addWidget(apply);
    apply_display = true;
  }
  
  /*top level name display*/
  QLabel *cpu = new QLabel();
  scpu.append("CPU : ");
  scpu.append(parse->getTopLevelName());
  scpu.append(" \n");
  cpu ->setText(QString::fromStdString(scpu));
  cpu->setFixedSize(350,50);
  pbox->addWidget(cpu);
  
   /*architecture in tree view display*/
   group = base->getGroups();
   for(QList<Group>::iterator it=group->begin();it!=group->end();++it){
   QLabel *lg = new QLabel();
   lgroup = "";
   lg->setFixedSize(200,30);
   ecart = "";
   if(it->getLevel() == 1)
     ecart.append("     ");
   if(it->getLevel() == 2)
     ecart.append("        ");
   if(it->getLevel() == 3)
     ecart.append("          ");
   if(it->getLevel() == 4)
     ecart.append("            ");
    if(it->getLevel() == 5)
      ecart.append("              ");
    lgroup.append(ecart);
    lgroup.append("<");
    lgroup.append(it->getName());
    lgroup.append(">");
    lg->setText(QString::fromStdString(lgroup));
    pbox->addWidget(lg);
    param = it->getParam();
    for(QList<Param>::iterator it2=param.begin();it2!=param.end();++it2){

      if(it2->getName() == "id"){
	QBoxLayout *b = new QBoxLayout(QBoxLayout::LeftToRight,0);
	QLabel *l = new QLabel();
	QString st2 = "   ";
	QString st;
	st2.append(QString::fromStdString(ecart));
	st2.append("nb_");
	st2.append(QString::fromStdString(it->getName()));

	st.append("nb_");
	st.append(QString::fromStdString(it->getName()));
	LimitParam lp = base->searchLimitParam(st.toStdString());

	QLabel *lab = new QLabel();
	QString s = "   ";
	s.append(QString::fromStdString(ecart));
	s.append(QString::fromStdString(it2->getName()));
	s.append(" : ");
	stringstream out;
	string str;
	out << it2->getValue();
	str = out.str();
	s.append(QString::fromStdString(str));
	lab->setText(s);
	pbox->addWidget(lab);
	l->setText(st2);
	QSpinBox *spin = new QSpinBox();
	int min = lp.getMin();
	int max = lp.getMax();
	QString step = QString::fromStdString(lp.getStep());
	
	spin->setValue(base->nbGroup(it->getName()));
	
	if(step.contains("+")){
	  step = step.right(step.length()-1);
	  int pas = step.toInt(0,10);
	  spin->setMinimum(min);
	  spin->setMaximum(max);
	  spin->setSingleStep(pas);
	}
      
	if(step.contains("*")){
	  step = step.right(step.length()-1);
	  int pas = step.toInt(0,10);
	  spin->setMinimum(min);
	  spin->setMaximum(max);
	  spin->setSingleStep(pas);
	}
	spin->setFixedSize(60,30);

	QString name_obj = (QString::fromStdString(it->getName()));
	spin->setObjectName(name_obj);

	b->addWidget(l);
	b->addWidget(spin);
	pbox->addLayout(b);

	connect(spin,SIGNAL(valueChanged(int)),this,SLOT(valueChanged(int)));

      }
      else{
	QBoxLayout *b = new QBoxLayout(QBoxLayout::LeftToRight,0);
	QLabel *l = new QLabel();
	sparam ="   ";
	sparam.append(ecart);
	sparam.append(it2->getName());
	sparam.append(" : ");
	stringstream out;
	string str;
	out << it2->getValue();
	str = out.str();
	sparam.append(str);
	l->setText(QString::fromStdString(sparam));
	l->setFixedSize(200,30);
	parameters->addWidget(l);
	QComboBox *cb = new QComboBox();
	LimitParam lp = base->searchLimitParam(it2->getName());
	int min = lp.getMin();
	int max = lp.getMax();
	QString step = QString::fromStdString(lp.getStep());
	int value = min;
	if(step.contains("+")){
	  step = step.right(step.length()-1);
	  int pas = step.toInt(0,10);
	  while(value!=max+pas){
	    stringstream out2;
	    string str2;
	    out2 << value;
	    str2 = out2.str();
	    cb->addItem(QString::fromStdString(str2));
	    value = value+pas;
	  }
	}
	if(step.contains("*")){
	  step = step.right(step.length()-1);
	  int pas = step.toInt(0,10);
	  while(value!=max*pas){
	    stringstream out2;
	    string str2;
	    out2 << value;
	    str2 = out2.str();
	    cb->addItem(QString::fromStdString(str2));
	    value = value*pas;
	  }
	}
	stringstream out3;
	string str3;
	out3 << it2->getValue();
	str3 = out3.str();
	int index = cb->findText(QString::fromStdString(str3));
	cb->setCurrentIndex(index);
	cb->setFixedSize(60,30);
	//QPushButton *pb = new QPushButton();
	//pb->setText("change");
	QString name_obj = (QString::fromStdString(it->getName()));
	name_obj.append(":");
	name_obj.append( QString::fromStdString(it2->getName()));
	name_obj.append(":");
	name_obj.append(cb->currentText());
	cb->setObjectName(name_obj);
	//cb->setFixedSize(60,30);
	QString new_value = cb->currentText();
	connect(cb,SIGNAL(currentIndexChanged(QString)),this,SLOT(currentIndexChanged(QString)));
	//connect(pb,SIGNAL(clicked()),this,SLOT(_change_value()));
	b->addWidget(l);
	b->addWidget(cb);
	//b->addWidget(pb);
	pbox->addLayout(b);
      }
    }
   }
  
  wscroll->setLayout(pbox);
  parameters->addWidget(wscroll);
  sc->setWidget(wscroll);
  if(scroll_hide){
    scroll_hide = false;
    wscroll->show();
  }
}

void Window::currentIndexChanged(QString value2){
  //cout << QObject::sender()->objectName().toStdString() << endl;
  
  QString obj = QObject::sender()->objectName();
  
  int i,j,v;
  QString param,group,value;
  i = obj.indexOf(":");
  group = obj.left(i);
  //cout << "group : " << group.toStdString() << endl;
  j = obj.indexOf(":",i+1);
  value = obj.right(obj.size() - j - 1);
  v = value2.toInt(0,10);
  cout << "value : " << v << endl; 
  param = obj.section(":",1,1);
  cout << "param : " << param.toStdString() << endl;

  base->modifyValue(group.toStdString(),param.toStdString(),v);
  wparam->close();
  apply_display = false;
  wparameters();
  display_param();
  parameter_modify = true;
}


void Window::valueChanged(int i){

  //cout << QObject::sender()->objectName().toStdString() << endl;

  QString obj = QObject::sender()->objectName();
  int v,j;
  cout << "name : " << obj.toStdString() << endl;
  v = i;
  //cout << "value : " << v << endl; 
  
  j = base->nbGroup(obj.toStdString());
  v = v - j;
  cout << "value : " << v << " " << j<< endl; 
  if(base->modifyGroup(obj.toStdString(),v)==-1){
    cout << "error" << endl;
    exit(1);
  }
  
  wparam->close();
  apply_display = false;
  wparameters();
  parameter_modify = true;
  display_param();
  //  base->afficheParamConsole();
}

/*apply the parameters changes*/
void Window::_apply(){
  if(!parameter_modify){
    QMessageBox *m = new QMessageBox(wparam);
    m->setText("no parameter changed");
    m->addButton("ok",QMessageBox::YesRole);
    m->show();
  }
  else{
    parameter_modify = false;
    cout << "apply\n";
  }
}
