#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {


  void Victim_Pseudo_LRU::vhdl_testbench_transition (Vhdl_Testbench & vhdl_testbench)
  {
#ifndef SYSTEMCASS_SPECIFIC
    sc_cycle(0);
#endif
    vhdl_testbench.add_input  (PORT_READ(in_NRESET));

    for (uint32_t i = 0; i < _param._nb_access; i ++)
      {
	vhdl_testbench.add_input  (PORT_READ( in_ACCESS_VAL     [i]));
	vhdl_testbench.add_output (PORT_READ(out_ACCESS_ACK     [i]));
	if (_param._size_table>1)
	  vhdl_testbench.add_input  (PORT_READ( in_ACCESS_ADDRESS [i]));
	vhdl_testbench.add_output (PORT_READ(out_ACCESS_ENTITY  [i]));
      }

    for (uint32_t i = 0; i < _param._nb_update; i ++)
      {
	vhdl_testbench.add_input  (PORT_READ( in_UPDATE_VAL     [i]));
	vhdl_testbench.add_output (PORT_READ(out_UPDATE_ACK     [i]));
	if (_param._size_table>1)
	  vhdl_testbench.add_input  (PORT_READ( in_UPDATE_ADDRESS [i]));
	vhdl_testbench.add_input  (PORT_READ( in_UPDATE_ENTITY  [i]));
      }

    vhdl_testbench.add_test(true);

    vhdl_testbench.new_cycle (); // always at the end
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
