/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"


namespace morpheo              {
namespace behavioural          {

  ostream& operator<< (ostream& output_stream,
		       morpheo::behavioural::Interface & x)
  {
    log_printf(FUNC,Behavioural,"operator<<","Begin");
    output_stream << x._name + "\t"+toString(x._localisation)+"\t"+toString(x._direction) << endl;
    output_stream << x.get_comment() << endl;
    output_stream << x.get_signal () << endl;

#ifdef VHDL_TESTBENCH
    if (x._list_cycle->empty()== false)
      {
	list<string>::iterator i = x._list_cycle->begin();

	while (i != x._list_cycle->end())
	  {
	    output_stream << "\n\t" << *i ;
	    ++i;
	  }
      }
#endif

    log_printf(FUNC,Behavioural,"operator<<","End");
    return output_stream;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
