#ifdef VHDL_TESTBENCH

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interfaces.h"

namespace morpheo              {
namespace behavioural          {

  void Interfaces::testbench_generate_file  (void)  
  {
    log_printf(FUNC,Behavioural,"generate_file","Begin");

    Vhdl   * vhdl        = new Vhdl(_name+"_Testbench");
    string   counter     = "counter";
    string   clock       = this->get_clock();
    uint32_t cycle       = this->get_cycle();

    vhdl      ->set_signal    (counter, "natural", "0");
    vhdl      ->set_signal    (clock  , 1        , 0); // modif Signal_set_signal
    this->set_signal    (vhdl);

    vhdl->set_body("");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("-- Component");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("");

    list<string> * list_signal = new list<string>;
    this->get_signal (list_signal);

    vhdl->set_library_work (_name + "_Pack");
    vhdl->set_body("instance_"+_name+" : "+_name);
    vhdl->set_body("port map (");
    
    list<string>::iterator i   = list_signal->begin();
    if (i != list_signal->end())
      {
        vhdl->set_body("\t "+*i+"\t=>\t"+*i);
        ++i;
      }
    while (i != list_signal->end())
      {
        vhdl->set_body("\t,"+*i+"\t=>\t"+*i);
        ++i;
      }
    vhdl->set_body("         );");

    delete list_signal;

    vhdl->set_body("");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("-- Port's affectation");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("");
    string test_name = this->testbench_body(vhdl,counter);

    vhdl->set_body("");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("-- process clock");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("");
    vhdl->set_body(clock+" <= not "+clock+" after 50 ns;");
    vhdl->set_body("");
    vhdl->set_body("process ("+clock+")");
    vhdl->set_body("begin");
    vhdl->set_body("\tif "+clock+"'event and "+clock+" = '1' then");
    vhdl->set_body("\t\t"+counter+" <= "+counter+"+1;");
    vhdl->set_body("");
    vhdl->set_body("\t\tassert     ("+test_name+" = '1') report \"Test KO\" severity FAILURE;");
    vhdl->set_body("\t\tassert not ("+counter+" = "+toString(cycle)+") report \"Test OK\" severity FAILURE;");
    vhdl->set_body("");
    vhdl->set_body("\tend if;");
    vhdl->set_body("end process;");

    vhdl->generate_file();

    delete vhdl;
    
    log_printf(FUNC,Behavioural,"generate_file","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
