/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/include/RegisterFile_Multi_Banked_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile{
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {


#ifdef SYSTEMC
  RegisterFile_Multi_Banked_Glue::RegisterFile_Multi_Banked_Glue (sc_module_name name,
#else
  RegisterFile_Multi_Banked_Glue::RegisterFile_Multi_Banked_Glue (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::Parameters param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Begin");

#ifdef SYSTEMC
    // write function pointer
    if (_crossbar == PARTIAL_CROSSBAR)
      {
	link_port_read_in_to_out     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::partial_crossbar_link_port_read_in_to_out    ;
 	link_port_read_in_to_select  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::partial_crossbar_link_port_read_in_to_select ;
 	link_port_write_in_to_out    = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::partial_crossbar_link_port_write_in_to_out   ;
 	link_port_write_in_to_select = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::partial_crossbar_link_port_write_in_to_select;
      }
    else
      {
 	link_port_read_in_to_out     = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::   full_crossbar_link_port_read_in_to_out    ;
 	link_port_read_in_to_select  = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::   full_crossbar_link_port_read_in_to_select ;
 	link_port_write_in_to_out    = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::   full_crossbar_link_port_write_in_to_out   ;
 	link_port_write_in_to_select = &morpheo::behavioural::generic::registerfile::registerfile_multi_banked::registerfile_multi_banked_glue::RegisterFile_Multi_Banked_Glue::   full_crossbar_link_port_write_in_to_select;
      }
#endif

#ifdef STATISTICS
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Creation of a testbench");

    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    _vhdl_testbench = new Vhdl_Testbench (_name);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Generate the vhdl");

    vhdl();
#endif

#ifdef VHDL_TESTBENCH
    _vhdl_testbench->set_clock    ("in_CLOCK",false);
#endif

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Allocation");

    allocation ();
    
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
#endif

    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","Method - transition");

    SC_METHOD (genMealy_read_in);
    dont_initialize ();
    for (uint32_t l=0; l<_param._nb_port_read; l++)
      sensitive << (*(in_READ_IN_ADDRESS [l]));
    for (uint32_t i=0; i<_param._nb_bank; i++)
       for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	 {
	   sensitive << (*(in_READ_OUT_ACK      [i][j]))
		     << (*(in_READ_OUT_DATA     [i][j]));
	   for (uint32_t k=0; k<_param._nb_port_select_by_bank_read_port[j]; k++)
	     sensitive << (*(in_READ_SELECT_ACK [i][j][k]));
	 }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t l=0; l<_param._nb_port_read; l++)
      {
	(*(out_READ_IN_ACK  [l])) (*(in_READ_IN_ADDRESS [l]));
	(*(out_READ_IN_DATA [l])) (*(in_READ_IN_ADDRESS [l]));

	for (uint32_t i=0; i<_param._nb_bank; i++)
	  for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	    {
	      (*(out_READ_IN_ACK  [l])) (*(in_READ_OUT_ACK      [i][j]));
	      (*(out_READ_IN_DATA [l])) (*(in_READ_OUT_DATA     [i][j]));
	      for (uint32_t k=0; k<_param._nb_port_select_by_bank_read_port[j]; k++)
		{
		  (*(out_READ_IN_ACK  [l])) (*(in_READ_SELECT_ACK [i][j][k]));
		  (*(out_READ_IN_DATA [l])) (*(in_READ_SELECT_ACK [i][j][k]));
		}
	    }
      }
#endif    

#endif
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"RegisterFile_Multi_Banked_Glue","End");
  };
  
  RegisterFile_Multi_Banked_Glue::~RegisterFile_Multi_Banked_Glue (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"~RegisterFile_Multi_Banked_Glue","Begin");

#ifdef VHDL_TESTBENCH
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"~RegisterFile_Multi_Banked_Glue","Generate Testbench  file");

    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"~RegisterFile_Multi_Banked_Glue","Generate Statistics file");

    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    log_printf(INFO,RegisterFile_Multi_Banked_Glue,"~RegisterFile_Multi_Banked_Glue","Deallocation");

    deallocation ();
#endif

    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"~RegisterFile_Multi_Banked_Glue","End");
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
