#ifndef morpheo_behavioural_generic_shifter_Parameters_h
#define morpheo_behavioural_generic_shifter_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Shifter/include/Types.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _size_data           ;
  public : const uint32_t    _nb_port             ;
  public : const uint32_t    _shift_value         ; // 0 = external shifter's value 
  public : const rotate_t    _rotate              ;
  public : const direction_t _direction           ;
  public : const carry_t     _carry               ;
  public : const uint32_t    _size_data_completion;
  public : const bool        _type_completion_bool;

  public : const bool        _internal_direction;
  public : const bool        _internal_type     ;
  public : const bool        _internal_carry    ;

  public : const bool        _have_shift_logic_left        ;
  public : const bool        _have_shift_logic_right       ;
  public : const bool        _have_shift_logic             ;
  public : const bool        _have_shift_arithmetic_left   ;
  public : const bool        _have_shift_arithmetic_right  ;
  public : const bool        _have_shift_arithmetic        ;
  public : const bool        _have_shift                   ;
  public : const bool        _have_rotate_left             ;
  public : const bool        _have_rotate_right            ;
  public : const bool        _have_rotate                  ;
    
  public : const bool        _have_direction_left          ;
  public : const bool        _have_direction_right         ;

    string toString_rotate    (rotate_t x)
    {
      switch (x)
	{
	case without_rotate            : return "without_rotate" ;
	case internal_rotate           : return "internal_rotate";
	case external_rotate           : return "external_rotate";     
	default                        : return "";
	}
    };
    
    string toString_direction (direction_t x) 
    {
      switch (x)
	{
	case internal_right_shift      : return "internal_right_shift";
	case internal_left_shift       : return "internal_left_shift" ;
	case external_direction        : return "external_direction"  ;
	default                        : return "";
	}
    };
    
    string toString_carry (carry_t x)
    {
      switch (x)
	{
	case internal_logic            : return "internal_logic"       ;
	case internal_arithmetic       : return "internal_arithmetic"  ;
	case external_carry            : return "external_carry"       ;
	case external_completion       : return "external_completion"  ;
	default                        : return "";
	}
    };
    
    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    size_data           ,
			uint32_t    nb_port             ,
			uint32_t    shift_value         ,
			rotate_t    rotate              ,
			direction_t direction           ,
			carry_t     carry               ,
			bool        type_completion_bool = false);
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::generic::shifter::Parameters & x);
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
