#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Branch_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  void Branch_History_Table::vhdl_body (Vhdl * & vhdl)
  {
//     vhdl->set_body ("-- Output : always at '1'");
//     for (uint32_t i=0; i<_param._nb_branch_complete; i++)
//       vhdl->set_body ("out_BRANCH_COMPLETE_ACK_"+toString(i)+" <= '1';");
//     for (uint32_t i=0; i<_param._nb_prediction     ; i++)
//       vhdl->set_body ("out_PREDICT_ACK_"+toString(i)+"         <= '1';");
//     vhdl->set_body ("");

    list<string> list_port_map;

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl->set_body_component_port_map (list_port_map," in_SHIFTER_"+toString(i)+"_DATA     ","    in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"  );
	vhdl->set_body_component_port_map (list_port_map," in_SHIFTER_"+toString(i)+"_CARRY_IN ","    in_BRANCH_COMPLETE_"+toString(i)+"_DIRECTION");
	vhdl->set_body_component_port_map (list_port_map,"out_SHIFTER_"+toString(i)+"_DATA     ","signal_BRANCH_COMPLETE_"+toString(i)+"_HISTORY"  );
      }

    vhdl->set_body_component ("component_Shifter",_name+"_Shifter",list_port_map);

    list_port_map.clear();
    vhdl->set_body_component_port_map (list_port_map,"in_CLOCK","in_CLOCK");
    vhdl->set_body_component_port_map (list_port_map,"in_NRESET","in_NRESET");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl->set_body_component_port_map (list_port_map," in_READ_"+toString(i)+"_VAL     "," In_PREDICT_"+toString(i)+"_VAL");
	vhdl->set_body_component_port_map (list_port_map,"out_READ_"+toString(i)+"_ACK     ","out_PREDICT_"+toString(i)+"_ACK");
	vhdl->set_body_component_port_map (list_port_map," in_READ_"+toString(i)+"_ADDRESS "," in_PREDICT_"+toString(i)+"_ADDRESS");
	vhdl->set_body_component_port_map (list_port_map,"out_READ_"+toString(i)+"_DATA    ","out_PREDICT_"+toString(i)+"_HISTORY");
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl->set_body_component_port_map (list_port_map," in_WRITE_"+toString(i)+"_VAL    ","    in_BRANCH_COMPLETE_"+toString(i)+"_VAL");
	vhdl->set_body_component_port_map (list_port_map,"out_WRITE_"+toString(i)+"_ACK    ","   out_BRANCH_COMPLETE_"+toString(i)+"_ACK");
	vhdl->set_body_component_port_map (list_port_map," in_WRITE_"+toString(i)+"_ADDRESS","    in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS");
	vhdl->set_body_component_port_map (list_port_map," in_WRITE_"+toString(i)+"_DATA   ","signal_BRANCH_COMPLETE_"+toString(i)+"_HISTORY");
      }
    vhdl->set_body_component ("component_RegisterFile",_name+"_RegisterFile",list_port_map);
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
