#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_Meta_Predictor_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_Meta_Predictor_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Include/ToString.h"
#include "Include/Debug.h"

// Internal structure
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  class Meta_Predictor 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

#ifdef VHDL_TESTBENCH
  private   : Vhdl_Testbench                 * _vhdl_testbench;
#endif

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // Interface Predict
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL                ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK                ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS            ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY            ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION          ;
			
    // Interface Branch_complete
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_VAL        ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK        ;
  public    : SC_IN (Taddress_t)           **  in_BRANCH_COMPLETE_ADDRESS    ;
  public    : SC_IN (Thistory_t)           **  in_BRANCH_COMPLETE_HISTORY    ;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_DIRECTION  ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Two_Level_Branch_Predictor * component_Two_Level_Branch_Predictor_0;
  public    : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Two_Level_Branch_Predictor * component_Two_Level_Branch_Predictor_1;
  public    : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Two_Level_Branch_Predictor * component_Two_Level_Branch_Predictor_2;
  public    : morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::meta_predictor_glue::Meta_Predictor_Glue               * component_Meta_Predictor_Glue         ;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // Interface Predict
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_PREDICT_PREDICTOR_0_ACK ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_PREDICT_PREDICTOR_1_ACK ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_PREDICT_PREDICTOR_2_ACK ;

  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_PREDICT_PREDICTOR_0_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_PREDICT_PREDICTOR_0_PHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_PREDICT_PREDICTOR_1_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_PREDICT_PREDICTOR_1_PHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_PREDICT_PREDICTOR_2_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_PREDICT_PREDICTOR_2_PHT_HISTORY;


  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PREDICTOR_0_ACK ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PREDICTOR_1_ACK ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PREDICTOR_2_VAL ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PREDICTOR_2_ACK ;
  private   : SC_SIGNAL(Tcontrol_t)        ** signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION;

  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tbht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY;
  private   : SC_SIGNAL(morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::Tpht_history_t) ** signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY;

#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Meta_Predictor);
#endif
  public  :          Meta_Predictor              (
#ifdef SYSTEMC
					      sc_module_name                              name,
#else					       
					      string                                      name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					      Parameters                                  param );
					       
  public  :          Meta_Predictor              (Parameters param );
  public  :          ~Meta_Predictor             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
				
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                (void);
#endif
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl & vhdl);
  private : void     vhdl_declaration          (Vhdl & vhdl);
  private : void     vhdl_body                 (Vhdl & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_port       (void);
  private : void     vhdl_testbench_transition (void);
#endif
  public  : void     vhdl_testbench_label      (string label);
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
