/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface.h"

namespace morpheo              {
namespace behavioural          {

  Signal * Interface::set_signal (string          name     ,
				  direction_t     direction,
				  uint32_t        size     ,
				  presence_port_t presence_port)
  {
    log_printf(FUNC,Behavioural,"set_signal","Begin");

    string signame = signal_name(_name, name, direction);

    Signal * sig = new Signal       (signame, direction, size, presence_port);

    _list_signal->push_back (sig);

    log_printf(FUNC,Behavioural,"set_signal","End");

    return sig;
  };

#ifdef VHDL
#  ifdef VHDL_TESTBENCH
  void Interface::set_signal (Vhdl * & vhdl)
  {
    if (not _list_signal->empty())
      {
	list<Signal*>::iterator i = _list_signal->begin();
	
	while (i != _list_signal->end())
	  {
	    (*i)->set_signal (vhdl);
	    ++i;
	  }
      }
  };
#  endif
#endif

}; // end namespace behavioural          
}; // end namespace morpheo              
